/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.fragment.bundle.watcher.internal;

import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;

@Component(service={})
public class PortalFragmentBundleWatcher {
    private BundleContext _bundleContext;
    private BundleTracker<String> _installedFragmentBundleTracker;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    private BundleListener _resolvedBundleListener;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._installedFragmentBundleTracker = new BundleTracker<String>(this._bundleContext, 2, null){

            public String addingBundle(Bundle bundle, BundleEvent event) {
                if (!PortalFragmentBundleWatcher.this._isFragment(bundle)) {
                    return null;
                }
                return PortalFragmentBundleWatcher.this._getFragmentHost(bundle);
            }
        };
        this._installedFragmentBundleTracker.open();
        Bundle systemBundle = this._bundleContext.getBundle(0L);
        FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        this._resolvedBundleListener = bundleEvent -> {
            Map installedFragmentBundles = this._installedFragmentBundleTracker.getTracked();
            if (installedFragmentBundles.isEmpty()) {
                return;
            }
            Bundle bundleEventBundle = bundleEvent.getBundle();
            Bundle originBundle = bundleEvent.getOrigin();
            ArrayList<Bundle> hostBundles = new ArrayList<Bundle>();
            if (bundleEvent.getType() == 1 && bundleEventBundle.getState() != 1 && this._isFragment(bundleEventBundle) && !Objects.equals(originBundle.getSymbolicName(), "com.liferay.portal.file.install.impl") && !this._hasMissingRequirements(frameworkWiring, bundleEventBundle)) {
                String hostBundleSymbolicName = (String)installedFragmentBundles.remove(bundleEventBundle);
                if (Validator.isNotNull((String)hostBundleSymbolicName)) {
                    for (Bundle bundle : bundleContext.getBundles()) {
                        if (!Objects.equals(bundle.getSymbolicName(), hostBundleSymbolicName) || !this._isHostBundleStateValid(bundle)) continue;
                        hostBundles.add(bundle);
                        break;
                    }
                }
            } else if (bundleEvent.getType() == 32 && !this._isFragment(bundleEventBundle)) {
                HashMap<String, List> fragmentBundlesMap = new HashMap<String, List>();
                for (Map.Entry entry : installedFragmentBundles.entrySet()) {
                    List fragmentBundles = fragmentBundlesMap.computeIfAbsent((String)entry.getValue(), key -> new ArrayList());
                    fragmentBundles.add(entry.getKey());
                }
                long originBundleId = originBundle.getBundleId();
                for (Bundle bundle : bundleContext.getBundles()) {
                    List fragmantBundles = (List)fragmentBundlesMap.remove(bundle.getSymbolicName());
                    if (fragmantBundles == null) continue;
                    if (originBundleId != bundle.getBundleId()) {
                        boolean needRefresh = false;
                        for (Bundle fragmentBundle : fragmantBundles) {
                            if (fragmentBundle.getState() != 2 || this._hasMissingRequirements(frameworkWiring, fragmentBundle)) continue;
                            needRefresh = true;
                            break;
                        }
                        if (needRefresh && this._isHostBundleStateValid(bundle)) {
                            hostBundles.add(bundle);
                        }
                    }
                    if (!fragmentBundlesMap.isEmpty()) {
                        continue;
                    }
                    break;
                }
            }
            if (!hostBundles.isEmpty()) {
                frameworkWiring.refreshBundles(hostBundles, new FrameworkListener[0]);
            }
        };
        this._bundleContext.addBundleListener(this._resolvedBundleListener);
    }

    @Deactivate
    protected void deactivate() {
        this._bundleContext.removeBundleListener(this._resolvedBundleListener);
        this._installedFragmentBundleTracker.close();
    }

    private String _getFragmentHost(Bundle bundle) {
        Dictionary dictionary = bundle.getHeaders("");
        String fragmentHost = (String)dictionary.get("Fragment-Host");
        if (fragmentHost == null) {
            return null;
        }
        int index = fragmentHost.indexOf(59);
        if (index != -1) {
            fragmentHost = fragmentHost.substring(0, index);
        }
        return fragmentHost;
    }

    private boolean _hasMissingRequirements(FrameworkWiring frameworkWiring, Bundle bundle) {
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        for (Requirement requirement : bundleRevision.getRequirements(null)) {
            Collection providers = frameworkWiring.findProviders(requirement);
            if (!providers.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean _isFragment(Bundle bundle) {
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        return (bundleRevision.getTypes() & 1) != 0;
    }

    private boolean _isHostBundleStateValid(Bundle bundle) {
        int hostBundleState = bundle.getState();
        return hostBundleState == 32 || hostBundleState == 4 || hostBundleState == 8;
    }
}

