/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal.activator;

import com.liferay.portal.file.install.FileInstaller;
import com.liferay.portal.file.install.internal.DefaultJarInstaller;
import com.liferay.portal.file.install.internal.DirectoryWatcher;
import com.liferay.portal.file.install.internal.Scanner;
import com.liferay.portal.file.install.internal.configuration.ConfigurationFileInstaller;
import com.liferay.portal.file.install.internal.configuration.FileSyncConfigurationListener;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FileInstallImplBundleActivator
implements BundleActivator {
    private BundleContext _bundleContext;
    private DirectoryWatcher _directoryWatcher;
    private ServiceRegistration<FileInstaller> _jarFileInstallerServiceRegistration;
    private ServiceTracker<ConfigurationAdmin, List<ServiceRegistration<?>>> _serviceTracker;

    public void start(final BundleContext bundleContext) throws Exception {
        this._bundleContext = bundleContext;
        this._jarFileInstallerServiceRegistration = this._bundleContext.registerService(FileInstaller.class, (Object)new DefaultJarInstaller(), null);
        this._serviceTracker = new ServiceTracker(bundleContext, ConfigurationAdmin.class.getName(), new ServiceTrackerCustomizer<ConfigurationAdmin, List<ServiceRegistration<?>>>(){

            public List<ServiceRegistration<?>> addingService(ServiceReference<ConfigurationAdmin> serviceReference) {
                ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)bundleContext.getService(serviceReference);
                return Arrays.asList(FileInstallImplBundleActivator.this._bundleContext.registerService(FileInstaller.class.getName(), (Object)new ConfigurationFileInstaller(configurationAdmin, PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_CONFIG_ENCODING), null), FileInstallImplBundleActivator.this._bundleContext.registerService(ConfigurationListener.class.getName(), (Object)new FileSyncConfigurationListener(configurationAdmin, FileInstallImplBundleActivator.this, PropsValues.MODULE_FRAMEWORK_FILE_INSTALL_CONFIG_ENCODING), null));
            }

            public void modifiedService(ServiceReference<ConfigurationAdmin> serviceReference, List<ServiceRegistration<?>> serviceRegistrations) {
            }

            public void removedService(ServiceReference<ConfigurationAdmin> serviceReference, List<ServiceRegistration<?>> serviceRegistrations) {
                for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
                    serviceRegistration.unregister();
                }
                bundleContext.ungetService(serviceReference);
            }
        });
        this._serviceTracker.open();
        this._directoryWatcher = new DirectoryWatcher(this._bundleContext);
        this._directoryWatcher.start();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this._directoryWatcher.close();
        this._serviceTracker.close();
        this._jarFileInstallerServiceRegistration.unregister();
    }

    public void updateChecksum(File file) {
        Scanner scanner = this._directoryWatcher.getScanner();
        scanner.updateChecksum(file);
    }
}

