/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal.properties;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.file.install.internal.properties.ConfigurationHandler;
import com.liferay.portal.file.install.internal.properties.InterpolationUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypedProperties {
    private static final String _EQUALS_WITH_SPACES = " = ";
    private static final String _LINE_SEPARATOR = System.getProperty("line.separator");
    private static final char[] _WHITE_SPACE = new char[]{' ', '\t', '\f'};
    private static final Log _log = LogFactoryUtil.getLog(TypedProperties.class);
    private String _header;
    private final Map<String, Map.Entry<String, List<String>>> _storage = new LinkedHashMap<String, Map.Entry<String, List<String>>>();

    public Object get(String key) {
        Map.Entry<String, List<String>> entry = this._storage.get(key);
        if (entry == null) {
            return null;
        }
        String string = entry.getKey();
        if (string != null) {
            return this._convertFromString(string);
        }
        return string;
    }

    public Set<String> keySet() {
        return this._storage.keySet();
    }

    public void load(Reader reader) throws IOException {
        PropertiesReader propertiesReader = new PropertiesReader(reader);
        while (propertiesReader.nextProperty()) {
            this._storage.put(propertiesReader.getPropertyName(), new AbstractMap.SimpleImmutableEntry<String, List<String>>(propertiesReader.getPropertyValue(), propertiesReader.getValues()));
        }
        this._header = propertiesReader.getComment();
    }

    public void put(String key, Object value) {
        Map.Entry<String, List<String>> oldEntry = this._storage.get(key);
        List<String> values = null;
        if (oldEntry != null) {
            Object oldObject = this._convertFromString(oldEntry.getKey());
            if (Objects.equals(oldObject, value)) {
                values = oldEntry.getValue();
            } else {
                Class<?> clazz = value.getClass();
                if (clazz.isArray() && Objects.deepEquals(oldObject, value)) {
                    values = oldEntry.getValue();
                }
            }
        }
        this._storage.put(key, new AbstractMap.SimpleImmutableEntry<String, Object>(this._convertToString(value), values));
    }

    public void remove(String key) {
        this._storage.remove(key);
    }

    public void save(Writer writer) throws IOException {
        StringBundler sb = new StringBundler();
        if (this._header != null) {
            sb.append(this._header);
            sb.append(_LINE_SEPARATOR);
        }
        for (Map.Entry<String, Map.Entry<String, List<String>>> entry : this._storage.entrySet()) {
            Map.Entry<String, List<String>> valuesEntry = entry.getValue();
            List<String> layout = valuesEntry.getValue();
            if (layout == null || layout.isEmpty()) {
                sb.append(entry.getKey());
                sb.append(_EQUALS_WITH_SPACES);
                sb.append(valuesEntry.getKey());
                sb.append(_LINE_SEPARATOR);
                continue;
            }
            int size = layout.size();
            for (int i = 0; i < size; ++i) {
                String string = layout.get(i);
                sb.append(string);
                if (i < size - 1) {
                    sb.append("\\");
                }
                sb.append(_LINE_SEPARATOR);
            }
        }
        sb.setIndex(sb.index() - 1);
        writer.write(sb.toString());
    }

    private Object _convertFromString(String value) {
        try {
            return ConfigurationHandler.read(value);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private String _convertToString(Object value) {
        try {
            return ConfigurationHandler.write(value);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private boolean _isCommentLine(String line) {
        String string = line.trim();
        return string.length() < 1 || '#' == string.charAt(0);
    }

    private class PropertiesReader
    extends BufferedReader {
        private String _comment;
        private final Pattern _linePattern;
        private String _propertyName;
        private String _propertyValue;
        private final List<String> _values;

        public String getComment() {
            return this._comment;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public String getPropertyValue() {
            return this._propertyValue;
        }

        public List<String> getValues() {
            return new ArrayList<String>(this._values);
        }

        public boolean nextProperty() throws IOException {
            String line = this._readProperty();
            if (line == null) {
                return false;
            }
            Matcher matcher = this._linePattern.matcher(line);
            if (!matcher.matches()) {
                _log.error((Object)("Unable to parse config line: " + line));
                return false;
            }
            String key = matcher.group(1);
            String value = matcher.group(2);
            value = value.trim();
            this._propertyName = key.trim();
            this._propertyValue = InterpolationUtil.substVars(value);
            return true;
        }

        private PropertiesReader(Reader reader) {
            super(reader);
            this._linePattern = Pattern.compile("(\\s*[0-9a-zA-Z-_\\.]+\\s*)=(\\s*[TILFDXSCBilfdxscb]?(\\[[\\S\\s]*\\]|\\{[\\S\\s]*\\}|\\([\\S\\s]*\\)|\"[\\S\\s]*\")\\s*)");
            this._values = new ArrayList<String>();
        }

        private boolean _checkCombineLines(String line) {
            int bsCount = 0;
            for (int i = line.length() - 1; i >= 0 && line.charAt(i) == '\\'; --i) {
                ++bsCount;
            }
            return bsCount % 2 != 0;
        }

        private String _readProperty() throws IOException {
            this._values.clear();
            StringBundler sb = new StringBundler();
            while (true) {
                String line;
                if ((line = this.readLine()) == null) {
                    return null;
                }
                if (TypedProperties.this._isCommentLine(line)) {
                    if (this._comment == null && this._values.isEmpty()) {
                        this._comment = line;
                        continue;
                    }
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Multiple comment lines found: " + line));
                    continue;
                }
                boolean combine = this._checkCombineLines(line);
                if (combine) {
                    line = line.substring(0, line.length() - 1);
                }
                this._values.add(line);
                while (line.length() > 0 && ArrayUtil.contains((char[])_WHITE_SPACE, (char)line.charAt(0))) {
                    line = line.substring(1);
                }
                sb.append(line);
                if (!combine) break;
            }
            return sb.toString();
        }
    }
}

