/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

public class Scanner {
    public static final String SUBDIR_MODE_RECURSE = "recurse";
    private final FilenameFilter _filenameFilter;
    private final Map<File, Long> _lastChecksums = new HashMap<File, Long>();
    private final boolean _recurseSubdir;
    private final Map<File, Long> _storedChecksums = new HashMap<File, Long>();
    private final List<File> _watchedDirs;

    public Scanner(List<File> dirs, final String filterString, String subdirMode) {
        this._watchedDirs = this._canononize(dirs);
        this._filenameFilter = filterString != null && filterString.length() > 0 ? new FilenameFilter(){
            private final Pattern _pattern;
            {
                this._pattern = Pattern.compile(filterString);
            }

            @Override
            public boolean accept(File dir, String name) {
                Matcher matcher = this._pattern.matcher(name);
                return matcher.matches();
            }
        } : null;
        this._recurseSubdir = SUBDIR_MODE_RECURSE.equals(subdirMode);
    }

    public long getChecksum(File file) {
        Long checksum = this._storedChecksums.get(file);
        if (checksum != null) {
            return checksum;
        }
        return 0L;
    }

    public void initialize(Map<File, Long> checksums) {
        this._storedChecksums.putAll(checksums);
    }

    public Set<File> scan(boolean reportImmediately) {
        Set<File> files = this._processFiles(reportImmediately, this._list());
        return new TreeSet<File>(files);
    }

    public void updateChecksum(File file) {
        if (file != null && this._storedChecksums.containsKey(file)) {
            long newChecksum = Scanner._checksum(file);
            this._storedChecksums.put(file, newChecksum);
        }
    }

    private static long _checksum(File file) {
        CRC32 crc32 = new CRC32();
        Scanner._checksum(file, crc32);
        return crc32.getValue();
    }

    private static void _checksum(File file, CRC32 crc32) {
        File[] children;
        String name = file.getName();
        crc32.update(name.getBytes());
        if (file.isFile()) {
            Scanner._checksum(file.lastModified(), crc32);
            Scanner._checksum(file.length(), crc32);
        } else if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                Scanner._checksum(child, crc32);
            }
        }
    }

    private static void _checksum(long l, CRC32 crc32) {
        for (int i = 0; i < 8; ++i) {
            crc32.update((int)(l & 0xFFL));
            l >>= 8;
        }
    }

    private List<File> _canononize(List<File> files) {
        ArrayList<File> canonicalFiles = new ArrayList<File>(files.size());
        for (File file : files) {
            try {
                canonicalFiles.add(file.getCanonicalFile());
            }
            catch (IOException ioException) {
                canonicalFiles.add(file);
            }
        }
        return canonicalFiles;
    }

    private File[] _list() {
        ArrayList files = new ArrayList();
        for (File dir : this._watchedDirs) {
            File[] list = dir.listFiles(this._filenameFilter);
            if (list == null) continue;
            Collections.addAll(files, list);
        }
        return files.toArray(new File[0]);
    }

    private Set<File> _processFiles(boolean reportImmediately, File[] list) {
        if (list == null) {
            return new HashSet<File>();
        }
        HashSet<File> files = new HashSet<File>();
        HashSet<File> removed = new HashSet<File>(this._storedChecksums.keySet());
        for (File file : list) {
            if (file.isDirectory()) {
                if (!this._recurseSubdir) continue;
                files.addAll(this._processFiles(reportImmediately, file.listFiles(this._filenameFilter)));
                continue;
            }
            long lastChecksum = 0L;
            if (this._lastChecksums.get(file) != null) {
                lastChecksum = this._lastChecksums.get(file);
            }
            long storedChecksum = 0L;
            if (this._storedChecksums.get(file) != null) {
                storedChecksum = this._storedChecksums.get(file);
            }
            long newChecksum = Scanner._checksum(file);
            this._lastChecksums.put(file, newChecksum);
            if ((newChecksum == lastChecksum || reportImmediately) && newChecksum != storedChecksum) {
                this._storedChecksums.put(file, newChecksum);
                files.add(file);
            }
            removed.remove(file);
        }
        files.addAll(removed);
        for (File file : removed) {
            this._lastChecksums.remove(file);
            this._storedChecksums.remove(file);
        }
        return files;
    }
}

