/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal.properties;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.file.install.internal.properties.ConfigurationProperties;
import com.liferay.portal.file.install.internal.properties.InterpolationUtil;
import com.liferay.portal.file.install.properties.ConfigurationHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypedProperties
implements ConfigurationProperties {
    private static final String _EQUALS_WITH_SPACES = " = ";
    private static final String _LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Log _log = LogFactoryUtil.getLog(TypedProperties.class);
    private String _header;
    private final Map<String, Map.Entry<String, List<String>>> _storage = new LinkedHashMap<String, Map.Entry<String, List<String>>>();

    @Override
    public Object get(String key) throws IOException {
        Map.Entry<String, List<String>> entry = this._storage.get(key);
        if (entry == null) {
            return null;
        }
        String string = entry.getKey();
        return ConfigurationHandler.read((String)string);
    }

    @Override
    public Set<String> keySet() {
        return this._storage.keySet();
    }

    @Override
    public void load(Reader reader) throws IOException {
        PropertiesReader propertiesReader = new PropertiesReader(reader);
        while (propertiesReader.nextProperty()) {
            this._storage.put(propertiesReader.getPropertyName(), new AbstractMap.SimpleImmutableEntry<String, List<String>>(propertiesReader.getPropertyValue(), propertiesReader.getValues()));
        }
        this._header = propertiesReader.getComment();
    }

    @Override
    public void put(String key, Object value) throws IOException {
        Map.Entry<String, List<String>> oldEntry = this._storage.get(key);
        List<String> values = null;
        if (oldEntry != null) {
            Object oldObject = ConfigurationHandler.read((String)oldEntry.getKey());
            if (Objects.equals(oldObject, value)) {
                values = oldEntry.getValue();
            } else {
                Class<?> clazz = value.getClass();
                if (clazz.isArray() && Objects.deepEquals(oldObject, value)) {
                    values = oldEntry.getValue();
                }
            }
        }
        this._storage.put(key, new AbstractMap.SimpleImmutableEntry<String, Object>(ConfigurationHandler.write((Object)value), values));
    }

    @Override
    public void remove(String key) {
        this._storage.remove(key);
    }

    @Override
    public void save(Writer writer) throws IOException {
        if (this._header == null && this._storage.isEmpty()) {
            return;
        }
        StringBundler sb = new StringBundler();
        if (this._header != null) {
            sb.append(this._header);
            sb.append(_LINE_SEPARATOR);
        }
        for (Map.Entry<String, Map.Entry<String, List<String>>> entry : this._storage.entrySet()) {
            Map.Entry<String, List<String>> valuesEntry = entry.getValue();
            List<String> layout = valuesEntry.getValue();
            if (layout == null) {
                sb.append(entry.getKey());
                sb.append(_EQUALS_WITH_SPACES);
                sb.append(valuesEntry.getKey());
                sb.append(_LINE_SEPARATOR);
                continue;
            }
            int size = layout.size();
            for (int i = 0; i < size; ++i) {
                String string = layout.get(i);
                sb.append(string);
                if (i < size - 1) {
                    sb.append("\\");
                }
                sb.append(_LINE_SEPARATOR);
            }
        }
        sb.setIndex(sb.index() - 1);
        writer.write(sb.toString());
    }

    private boolean _isCommentLine(String line) {
        String string = line.trim();
        return '#' == string.charAt(0);
    }

    private class PropertiesReader
    extends BufferedReader {
        private String _comment;
        private final Pattern _linePattern;
        private String _propertyName;
        private String _propertyValue;
        private final List<String> _values;

        public String getComment() {
            return this._comment;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public String getPropertyValue() {
            return this._propertyValue;
        }

        public List<String> getValues() {
            return new ArrayList<String>(this._values);
        }

        public boolean nextProperty() throws IOException {
            String line = this._readProperty();
            if (line == null) {
                return false;
            }
            Matcher matcher = this._linePattern.matcher(line);
            if (!matcher.matches()) {
                _log.error((Object)("Unable to parse config line: " + line));
                return false;
            }
            String key = matcher.group(1);
            String value = matcher.group(2);
            value = InterpolationUtil.substVars(value.trim());
            this._propertyName = key.trim();
            this._propertyValue = value;
            return true;
        }

        private PropertiesReader(Reader reader) {
            super(reader);
            this._linePattern = Pattern.compile("(\\s*[0-9a-zA-Z-_\\.]+\\s*)=(\\s*[TILFDXSCBilfdxscb]?(\\[[\\S\\s]*\\]|\\{[\\S\\s]*\\}|\\([\\S\\s]*\\)|\"[\\S\\s]*\")\\s*)");
            this._values = new ArrayList<String>();
        }

        private boolean _checkCombineLines(String line) {
            return line.charAt(line.length() - 1) == '\\';
        }

        private String _readProperty() throws IOException {
            this._values.clear();
            StringBundler sb = new StringBundler();
            ArrayList<String> comments = new ArrayList<String>();
            while (true) {
                String line;
                if ((line = this.readLine()) == null) {
                    return null;
                }
                if (line.isEmpty()) {
                    this._values.add(line);
                    continue;
                }
                if (TypedProperties.this._isCommentLine(line)) {
                    comments.add(line);
                    if (!TypedProperties.this._storage.isEmpty()) {
                        _log.error((Object)("Comment must be at beginning of config file: " + line));
                        continue;
                    }
                    if (this._comment != null) continue;
                    this._comment = line;
                    continue;
                }
                boolean combine = this._checkCombineLines(line);
                if (combine) {
                    line = line.substring(0, line.length() - 1);
                }
                this._values.add(line);
                sb.append(line.trim());
                if (!combine) break;
            }
            if (comments.size() > 1) {
                _log.error((Object)("Multiple comment lines found: " + comments));
            }
            return sb.toString();
        }
    }
}

