/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal.properties;

import com.liferay.portal.file.install.internal.properties.CFGProperties;
import com.liferay.portal.file.install.internal.properties.ConfigurationProperties;
import com.liferay.portal.file.install.internal.properties.TypedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ConfigurationPropertiesFactory {
    public static ConfigurationProperties create(File file, String encoding) throws IOException {
        ConfigurationProperties configurationProperties = null;
        String name = file.getName();
        if (name.endsWith("config")) {
            configurationProperties = new TypedProperties();
        } else if (name.endsWith("cfg")) {
            configurationProperties = new CFGProperties();
        } else {
            throw new IllegalArgumentException("Unknown configuration type: " + file);
        }
        try (FileInputStream inputStream = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)inputStream, encoding);){
            configurationProperties.load(reader);
        }
        return configurationProperties;
    }
}

