/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal.properties;

import com.liferay.petra.io.unsync.UnsyncBufferedReader;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.file.install.internal.properties.ConfigurationProperties;
import com.liferay.portal.file.install.internal.properties.InterpolationUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CFGProperties
implements ConfigurationProperties {
    private static final String _LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern _configPattern = Pattern.compile("(\\s*[0-9a-zA-Z-_\\.]+\\s*)=(\\s*[TILFDXSCBilfdxscb]?(\\[[\\S\\s]*\\]|\\{[\\S\\s]*\\}|\\([\\S\\s]*\\)|\"[\\S\\s]*\")\\s*)");
    private final Map<String, Map.Entry<String, List<String>>> _storage = new LinkedHashMap<String, Map.Entry<String, List<String>>>();

    @Override
    public Object get(String key) throws IOException {
        Map.Entry<String, List<String>> entry = this._storage.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getKey();
    }

    @Override
    public Set<String> keySet() {
        return this._storage.keySet();
    }

    @Override
    public void load(Reader reader) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = this._wrap(reader);){
            String line = unsyncBufferedReader.readLine();
            ArrayList<String> lines = new ArrayList<String>();
            StringBundler sb = new StringBundler();
            while (line != null) {
                lines.add(line);
                if (line.length() < 1 || line.startsWith("#") || line.startsWith("!")) {
                    line = unsyncBufferedReader.readLine();
                    continue;
                }
                if (line.endsWith("\\")) {
                    String token = line.substring(0, line.length() - 1);
                    sb.append(token.trim());
                    line = unsyncBufferedReader.readLine();
                    continue;
                }
                sb.append(line.trim());
                line = sb.toString();
                Matcher matcher = _configPattern.matcher(line);
                if (matcher.matches()) {
                    throw new IllegalArgumentException("Detected .config format in .cfg file in line: " + line);
                }
                int index = line.indexOf(61);
                String key = line.substring(0, index);
                String value = line.substring(index + 1);
                this._storage.put(key.trim(), new AbstractMap.SimpleImmutableEntry(InterpolationUtil.substVars(value.trim()), new ArrayList(lines)));
                lines.clear();
                sb.setIndex(0);
                line = unsyncBufferedReader.readLine();
            }
        }
    }

    @Override
    public void put(String key, Object value) throws IOException {
        StringBundler sb = new StringBundler();
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object object : collection) {
                sb.append(object.toString());
                sb.append(",");
            }
            if (!collection.isEmpty()) {
                sb.setIndex(sb.index() - 1);
            }
        } else {
            Class<?> clazz = value.getClass();
            if (clazz.isArray()) {
                Object[] array;
                for (Object object : array = (Object[])value) {
                    sb.append(object.toString());
                    sb.append(",");
                }
                if (array.length > 0) {
                    sb.setIndex(sb.index() - 1);
                }
            } else {
                sb.append(value.toString());
            }
        }
        this._storage.put(key, new AbstractMap.SimpleImmutableEntry<String, Object>(sb.toString(), null));
    }

    @Override
    public void remove(String key) {
        this._storage.remove(key);
    }

    @Override
    public void save(Writer writer) throws IOException {
        StringBundler sb = new StringBundler();
        for (Map.Entry<String, Map.Entry<String, List<String>>> entry : this._storage.entrySet()) {
            Map.Entry<String, List<String>> values = entry.getValue();
            List<String> lines = values.getValue();
            if (lines == null) {
                sb.append(entry.getKey());
                sb.append("=");
                sb.append(values.getKey());
                sb.append(_LINE_SEPARATOR);
                continue;
            }
            for (String line : lines) {
                sb.append(line);
                sb.append(_LINE_SEPARATOR);
            }
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        writer.write(sb.toString());
    }

    private UnsyncBufferedReader _wrap(Reader reader) {
        if (reader == null) {
            return null;
        }
        return new UnsyncBufferedReader(reader);
    }
}

