/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.file.install.internal.configuration;

import com.liferay.portal.file.install.internal.FileInstallImplBundleActivator;
import com.liferay.portal.file.install.internal.properties.ConfigurationProperties;
import com.liferay.portal.file.install.internal.properties.ConfigurationPropertiesFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

public class FileSyncConfigurationListener
implements ConfigurationListener {
    private static final Log _log = LogFactoryUtil.getLog(FileSyncConfigurationListener.class);
    private final ConfigurationAdmin _configurationAdmin;
    private final String _encoding;
    private final FileInstallImplBundleActivator _fileInstallImplBundleActivator;
    private final Map<String, String> _pidToFile;

    public FileSyncConfigurationListener(ConfigurationAdmin configurationAdmin, FileInstallImplBundleActivator fileInstallImplBundleActivator, String encoding) {
        block5: {
            this._pidToFile = new HashMap<String, String>();
            this._configurationAdmin = configurationAdmin;
            this._fileInstallImplBundleActivator = fileInstallImplBundleActivator;
            this._encoding = encoding;
            try {
                Configuration[] configurations = this._configurationAdmin.listConfigurations(null);
                if (configurations != null) {
                    for (Configuration configuration : configurations) {
                        Dictionary dictionary = configuration.getProperties();
                        String fileName = null;
                        if (dictionary != null) {
                            fileName = (String)dictionary.get("felix.fileinstall.filename");
                        }
                        if (fileName == null) continue;
                        this._pidToFile.put(configuration.getPid(), fileName);
                    }
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)"Unable to initialize configurations", (Throwable)exception);
            }
        }
    }

    public void configurationEvent(ConfigurationEvent configurationEvent) {
        block38: {
            int type = configurationEvent.getType();
            if (type == 1) {
                try {
                    Configuration configuration = this._configurationAdmin.getConfiguration(configurationEvent.getPid(), "?");
                    Dictionary dictionary = configuration.getProperties();
                    String fileName = null;
                    if (dictionary != null) {
                        fileName = (String)dictionary.get("felix.fileinstall.filename");
                    }
                    File file = null;
                    if (fileName != null) {
                        file = this._fromConfigKey(fileName);
                    }
                    if (file == null || !file.isFile()) break block38;
                    this._pidToFile.put(configuration.getPid(), fileName);
                    ConfigurationProperties configurationProperties = ConfigurationPropertiesFactory.create(file, this._encoding);
                    ArrayList<String> toRemovePropertyKeys = new ArrayList<String>();
                    for (String string : configurationProperties.keySet()) {
                        if (dictionary.get(string) != null || Objects.equals("service.pid", string) || Objects.equals("service.factoryPid", string) || Objects.equals("felix.fileinstall.filename", string)) continue;
                        toRemovePropertyKeys.add(string);
                    }
                    Enumeration enumeration = dictionary.keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (Objects.equals("service.pid", string) || Objects.equals("service.factoryPid", string) || Objects.equals("felix.fileinstall.filename", string)) continue;
                        Object v = dictionary.get(string);
                        configurationProperties.put(string, v);
                    }
                    for (String string : toRemovePropertyKeys) {
                        configurationProperties.remove(string);
                    }
                    Throwable throwable = null;
                    try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                         OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, this._encoding);){
                        configurationProperties.save(writer);
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        throw throwable2;
                    }
                    this._fileInstallImplBundleActivator.updateChecksum(file);
                }
                catch (Exception exception) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)"Unable to save configuration", (Throwable)exception);
                    }
                    break block38;
                }
            }
            if (type == 2) {
                try {
                    String fileName = this._pidToFile.remove(configurationEvent.getPid());
                    File file = null;
                    if (fileName != null) {
                        file = this._fromConfigKey(fileName);
                    }
                    if (file != null && file.isFile() && !file.delete()) {
                        throw new IOException("Unable to delete file " + file);
                    }
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block38;
                    _log.warn((Object)"Unable to delete configuration file", (Throwable)exception);
                }
            }
        }
    }

    private File _fromConfigKey(String key) {
        return new File(URI.create(key));
    }
}

