/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.executor.internal;

import com.liferay.portal.kernel.concurrent.AbortPolicy;
import com.liferay.portal.kernel.concurrent.ClearThreadLocalThreadPoolHandler;
import com.liferay.portal.kernel.concurrent.RejectedExecutionHandler;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.concurrent.ThreadPoolHandler;
import com.liferay.portal.kernel.executor.PortalExecutorConfig;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={PortalExecutorFactory.class})
public class PortalExecutorFactory {
    public static final String DEFAULT_CONFIG_NAME = "default";
    private final PortalExecutorConfig _defaultPortalExecutorConfig = new PortalExecutorConfig("default", 0, 10, 60L, TimeUnit.SECONDS, true, Integer.MAX_VALUE, (RejectedExecutionHandler)new AbortPolicy(), (ThreadPoolHandler)new ClearThreadLocalThreadPoolHandler(), 5, PortalClassLoaderUtil.getClassLoader());
    private final ConcurrentMap<String, PortalExecutorConfig> _portalExecutorConfigs = new ConcurrentHashMap<String, PortalExecutorConfig>();

    public ThreadPoolExecutor createPortalExecutor(String executorName) {
        PortalExecutorConfig portalExecutorConfig = this.getPortalExecutorConfig(executorName);
        return new ThreadPoolExecutor(portalExecutorConfig.getCorePoolSize(), portalExecutorConfig.getMaxPoolSize(), portalExecutorConfig.getKeepAliveTime(), portalExecutorConfig.getTimeUnit(), portalExecutorConfig.isAllowCoreThreadTimeout(), portalExecutorConfig.getMaxQueueSize(), portalExecutorConfig.getRejectedExecutionHandler(), portalExecutorConfig.getThreadFactory(), portalExecutorConfig.getThreadPoolHandler());
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addPortalExecutorConfig(PortalExecutorConfig portalExecutorConfig) {
        this._portalExecutorConfigs.putIfAbsent(portalExecutorConfig.getName(), portalExecutorConfig);
    }

    protected PortalExecutorConfig getPortalExecutorConfig(String name) {
        PortalExecutorConfig portalExecutorConfig = (PortalExecutorConfig)this._portalExecutorConfigs.get(name);
        if (portalExecutorConfig != null) {
            return portalExecutorConfig;
        }
        portalExecutorConfig = (PortalExecutorConfig)this._portalExecutorConfigs.get(DEFAULT_CONFIG_NAME);
        if (portalExecutorConfig != null) {
            return portalExecutorConfig;
        }
        return this._defaultPortalExecutorConfig;
    }

    protected void removePortalExecutorConfig(PortalExecutorConfig portalExecutorConfig) {
        this._portalExecutorConfigs.remove(portalExecutorConfig.getName(), portalExecutorConfig);
    }
}

