/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.executor.internal;

import com.liferay.portal.executor.internal.PortalExecutorFactory;
import com.liferay.portal.kernel.concurrent.FutureListener;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.executor.PortalExecutorManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalExecutorManager.class})
public class PortalExecutorManagerImpl
implements PortalExecutorManager {
    private PortalExecutorFactory _portalExecutorFactory;
    private final ConcurrentMap<String, ThreadPoolExecutor> _threadPoolExecutors = new ConcurrentHashMap<String, ThreadPoolExecutor>();

    public ThreadPoolExecutor getPortalExecutor(String name) {
        return this.getPortalExecutor(name, true);
    }

    public ThreadPoolExecutor getPortalExecutor(String name, boolean createIfAbsent) {
        ThreadPoolExecutor previousThreadPoolExecutor;
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this._threadPoolExecutors.get(name);
        if (threadPoolExecutor == null && createIfAbsent && (previousThreadPoolExecutor = this.registerPortalExecutor(name, threadPoolExecutor = this._portalExecutorFactory.createPortalExecutor(name))) != null) {
            threadPoolExecutor.shutdown();
            threadPoolExecutor = previousThreadPoolExecutor;
        }
        return threadPoolExecutor;
    }

    public ThreadPoolExecutor registerPortalExecutor(String name, ThreadPoolExecutor threadPoolExecutor) {
        ThreadPoolExecutor previousThreadPoolExecutor = this._threadPoolExecutors.putIfAbsent(name, threadPoolExecutor);
        if (previousThreadPoolExecutor == null) {
            NoticeableFuture terminationNoticeableFuture = threadPoolExecutor.terminationNoticeableFuture();
            terminationNoticeableFuture.addFutureListener((FutureListener)new UnregisterFutureListener(name));
        }
        return previousThreadPoolExecutor;
    }

    @Reference(unbind="-")
    public void setPortalExecutorFactory(PortalExecutorFactory portalExecutorFactory) {
        this._portalExecutorFactory = portalExecutorFactory;
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean interrupt) {
        for (ThreadPoolExecutor threadPoolExecutor : this._threadPoolExecutors.values()) {
            if (interrupt) {
                threadPoolExecutor.shutdownNow();
                continue;
            }
            threadPoolExecutor.shutdown();
        }
    }

    @Deactivate
    protected void deactivate() {
        this.shutdown(true);
    }

    protected class UnregisterFutureListener
    implements FutureListener<Void> {
        protected final String name;

        public void complete(Future<Void> future) {
            PortalExecutorManagerImpl.this._threadPoolExecutors.remove(this.name);
        }

        protected UnregisterFutureListener(String name) {
            this.name = name;
        }
    }
}

