/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.encryptor;

import com.liferay.portal.kernel.encryptor.Encryptor;
import com.liferay.portal.kernel.encryptor.EncryptorException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.osgi.service.component.annotations.Component;

@Component(service={Encryptor.class})
public class EncryptorImpl
implements Encryptor {
    public static final String ENCODING = "UTF-8";
    public static final String IBM_PROVIDER_CLASS = "com.ibm.crypto.provider.IBMJCE";
    public static final String KEY_ALGORITHM = StringUtil.toUpperCase((String)GetterUtil.getString((String)PropsUtil.get((String)"company.encryption.algorithm")));
    public static final int KEY_SIZE = GetterUtil.getInteger((String)PropsUtil.get((String)"company.encryption.key.size"));
    public static final String PROVIDER_CLASS = GetterUtil.getString((String)SystemProperties.get((String)(EncryptorImpl.class.getName() + ".provider.class")), (String)"com.sun.crypto.provider.SunJCE");
    public static final String SUN_PROVIDER_CLASS = "com.sun.crypto.provider.SunJCE";
    private static final Log _log = LogFactoryUtil.getLog(EncryptorImpl.class);
    private static final Provider _provider;
    private final Map<String, Cipher> _decryptCipherMap = new ConcurrentHashMap<String, Cipher>(1, 1.0f, 1);
    private final Map<String, Cipher> _encryptCipherMap = new ConcurrentHashMap<String, Cipher>(1, 1.0f, 1);

    public String decrypt(Key key, String encryptedString) throws EncryptorException {
        byte[] encryptedBytes = Base64.decode((String)encryptedString);
        return this._decryptUnencodedAsString(key, encryptedBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decryptUnencodedAsBytes(Key key, byte[] encryptedBytes) throws EncryptorException {
        String algorithm = key.getAlgorithm();
        String cacheKey = algorithm + "#" + key.toString();
        Cipher cipher = this._decryptCipherMap.get(cacheKey);
        try {
            if (cipher == null) {
                cipher = Cipher.getInstance(algorithm);
                cipher.init(2, key);
                this._decryptCipherMap.put(cacheKey, cipher);
            }
            Cipher cipher2 = cipher;
            synchronized (cipher2) {
                return cipher.doFinal(encryptedBytes);
            }
        }
        catch (Exception exception) {
            throw new EncryptorException((Throwable)exception);
        }
    }

    public Key deserializeKey(String base64String) {
        byte[] bytes = Base64.decode((String)base64String);
        return new SecretKeySpec(bytes, KEY_ALGORITHM);
    }

    public String encrypt(Key key, String plainText) throws EncryptorException {
        if (key == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Skip encrypting based on a null key");
            }
            return plainText;
        }
        byte[] encryptedBytes = this.encryptUnencoded(key, plainText);
        return Base64.encode((byte[])encryptedBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encryptUnencoded(Key key, byte[] plainBytes) throws EncryptorException {
        String algorithm = key.getAlgorithm();
        String cacheKey = algorithm + "#" + key.toString();
        Cipher cipher = this._encryptCipherMap.get(cacheKey);
        try {
            if (cipher == null) {
                cipher = Cipher.getInstance(algorithm);
                cipher.init(1, key);
                this._encryptCipherMap.put(cacheKey, cipher);
            }
            Cipher cipher2 = cipher;
            synchronized (cipher2) {
                return cipher.doFinal(plainBytes);
            }
        }
        catch (Exception exception) {
            throw new EncryptorException((Throwable)exception);
        }
    }

    public byte[] encryptUnencoded(Key key, String plainText) throws EncryptorException {
        try {
            byte[] decryptedBytes = plainText.getBytes(ENCODING);
            return this.encryptUnencoded(key, decryptedBytes);
        }
        catch (Exception exception) {
            throw new EncryptorException((Throwable)exception);
        }
    }

    public Key generateKey() throws EncryptorException {
        return this._generateKey(KEY_ALGORITHM);
    }

    public String serializeKey(Key key) {
        return Base64.encode((byte[])key.getEncoded());
    }

    private String _decryptUnencodedAsString(Key key, byte[] encryptedBytes) throws EncryptorException {
        try {
            byte[] decryptedBytes = this.decryptUnencodedAsBytes(key, encryptedBytes);
            return new String(decryptedBytes, ENCODING);
        }
        catch (Exception exception) {
            throw new EncryptorException((Throwable)exception);
        }
    }

    private Key _generateKey(String algorithm) throws EncryptorException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
            keyGenerator.init(KEY_SIZE, new SecureRandom());
            return keyGenerator.generateKey();
        }
        catch (Exception exception) {
            throw new EncryptorException((Throwable)exception);
        }
    }

    static {
        try {
            Class<?> providerClass;
            block7: {
                providerClass = null;
                try {
                    providerClass = Class.forName(PROVIDER_CLASS);
                }
                catch (ClassNotFoundException classNotFoundException1) {
                    try {
                        if (PROVIDER_CLASS.equals(SUN_PROVIDER_CLASS)) {
                            providerClass = Class.forName(IBM_PROVIDER_CLASS);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        classNotFoundException1.addSuppressed(classNotFoundException2);
                    }
                    if (providerClass != null) break block7;
                    throw new IllegalStateException("Unable to find provider class: " + PROVIDER_CLASS, classNotFoundException1);
                }
            }
            _provider = (Provider)providerClass.newInstance();
            Security.addProvider(_provider);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

