/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.settings.internal;

import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsDescriptor;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class AnnotatedSettingsDescriptor
implements SettingsDescriptor {
    private final Set<String> _allKeys = new HashSet<String>();
    private final Set<String> _multiValuedKeys = new HashSet<String>();
    private final Class<?> _settingsClass;

    public AnnotatedSettingsDescriptor(Class<?> settingsClass) {
        this._settingsClass = settingsClass;
        Method[] methods = this._getPropertyMethods();
        this._initAllKeys(methods);
        this._initMultiValuedKeys(methods);
    }

    public Set<String> getAllKeys() {
        return this._allKeys;
    }

    public Set<String> getMultiValuedKeys() {
        return this._multiValuedKeys;
    }

    private Method[] _getPropertyMethods() {
        Method[] methods;
        ArrayList<Method> propertyMethods = new ArrayList<Method>();
        for (Method method : methods = this._settingsClass.getMethods()) {
            String name;
            Settings.Property settingsProperty = method.getAnnotation(Settings.Property.class);
            if (settingsProperty != null && settingsProperty.ignore() || (name = method.getName()).equals("getClass") || !name.startsWith("get") && !name.startsWith("is")) continue;
            propertyMethods.add(method);
        }
        return propertyMethods.toArray(new Method[0]);
    }

    private String _getPropertyName(Method propertyMethod) {
        String name;
        Settings.Property settingsProperty = propertyMethod.getAnnotation(Settings.Property.class);
        if (settingsProperty != null && !(name = settingsProperty.name()).isEmpty()) {
            return name;
        }
        name = propertyMethod.getName();
        if (name.startsWith("get")) {
            name = name.substring(3);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
        } else {
            throw new IllegalArgumentException("Invalid method name for getter " + propertyMethod.getName());
        }
        return StringUtil.toLowerCase((String)name.substring(0, 1)) + name.substring(1);
    }

    private void _initAllKeys(Method[] propertyMethods) {
        for (Method propertyMethod : propertyMethods) {
            this._allKeys.add(this._getPropertyName(propertyMethod));
        }
    }

    private void _initMultiValuedKeys(Method[] propertyMethods) {
        for (Method propertyMethod : propertyMethods) {
            Class<?> clazz = propertyMethod.getReturnType();
            if (clazz != String[].class) continue;
            this._multiValuedKeys.add(this._getPropertyName(propertyMethod));
        }
    }
}

