/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.settings.internal.scoped.configuration;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.configuration.metatype.util.ConfigurationScopedPidUtil;
import com.liferay.portal.configuration.settings.internal.scoped.configuration.ScopeKey;
import com.liferay.portal.configuration.settings.internal.scoped.configuration.ScopedConfigurationBeanManagedService;
import com.liferay.portal.configuration.settings.internal.util.ConfigurationPidUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.settings.definition.ConfigurationBeanDeclaration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={ConfigurationListener.class, ScopedConfigurationBeanConfigurationListener.class})
public class ScopedConfigurationBeanConfigurationListener
implements ConfigurationListener {
    private static final Log _log = LogFactoryUtil.getLog(ScopedConfigurationBeanConfigurationListener.class);
    private BundleContext _bundleContext;
    private final Map<String, Class<?>> _configurationBeanClasses = new ConcurrentHashMap();
    private final Map<ScopeKey, Object> _scopedConfigurationBeans = new ConcurrentHashMap<ScopeKey, Object>();

    public void configurationEvent(ConfigurationEvent event) {
        block6: {
            ExtendedObjectClassDefinition.Scope scope;
            if (event.getType() != 1) {
                return;
            }
            String pid = event.getFactoryPid();
            if (pid == null) {
                pid = event.getPid();
            }
            if (ExtendedObjectClassDefinition.Scope.SYSTEM == (scope = ConfigurationScopedPidUtil.getScope((String)pid))) {
                return;
            }
            try {
                ScopeKey scopeKey = new ScopeKey(this._configurationBeanClasses.get(ConfigurationScopedPidUtil.getBasePid((String)pid)), scope, ConfigurationScopedPidUtil.getScopePrimKey((String)pid));
                if (this._scopedConfigurationBeans.containsKey(scopeKey)) {
                    return;
                }
                ScopedConfigurationBeanManagedService configurationBeanManagedService = new ScopedConfigurationBeanManagedService(scopeKey, configurationBean -> {
                    if (configurationBean == null) {
                        this._scopedConfigurationBeans.remove(scopeKey);
                    } else {
                        this._scopedConfigurationBeans.put(scopeKey, configurationBean);
                    }
                });
                configurationBeanManagedService.register(this._bundleContext, pid);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                if (!_log.isInfoEnabled()) break block6;
                _log.info((Object)e, (Throwable)e);
            }
        }
    }

    public Object get(ScopeKey scopeKey) {
        return this._scopedConfigurationBeans.get(scopeKey);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addConfigurationBeanDeclaration(ConfigurationBeanDeclaration configurationBeanDeclaration) {
        Class configurationBeanClass = configurationBeanDeclaration.getConfigurationBeanClass();
        String configurationPid = ConfigurationPidUtil.getConfigurationPid(configurationBeanClass);
        this._configurationBeanClasses.put(configurationPid, configurationBeanClass);
    }

    protected void removeConfigurationBeanDeclaration(ConfigurationBeanDeclaration configurationBeanDeclaration) {
        String configurationPid = ConfigurationPidUtil.getConfigurationPid(configurationBeanDeclaration.getConfigurationBeanClass());
        this._configurationBeanClasses.remove(configurationPid);
    }
}

