/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.settings.internal.scoped.configuration;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;
import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ScopeKey {
    private final Class<?> _objectClass;
    private final ExtendedObjectClassDefinition.Scope _scope;
    private final String _scopePrimKey;

    public ScopeKey(Class<?> objectClass, ExtendedObjectClassDefinition.Scope scope, String scopePrimKey) {
        Objects.requireNonNull(objectClass, "The object class parameter must not be null. A scope key must correspond to an existing configuration bean class.");
        Objects.requireNonNull(scope, StringBundler.concat((String[])new String[]{"The scope parameter must not be null. A scope key must ", "correspond to an existing scope from ", ExtendedObjectClassDefinition.Scope.class.getName(), "."}));
        if (scope.equals((Object)ExtendedObjectClassDefinition.Scope.SYSTEM)) {
            Stream<ExtendedObjectClassDefinition.Scope> scopeStream = Arrays.stream(ExtendedObjectClassDefinition.Scope.values());
            String scopeNames = scopeStream.filter(scope1 -> !scope1.equals((Object)ExtendedObjectClassDefinition.Scope.SYSTEM)).map(scope1 -> scope1.name()).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"A scope key can only be used for the following scopes ", "from ", ExtendedObjectClassDefinition.Scope.class.getName(), ": ", scopeNames, "."}));
        }
        if (Validator.isNull((String)scopePrimKey)) {
            throw new IllegalArgumentException(StringBundler.concat((String[])new String[]{"The scope primary key parameter must not be null. A ", "scope key must correspond to a primary key for the given ", "scope."}));
        }
        this._objectClass = objectClass;
        this._scope = scope;
        this._scopePrimKey = scopePrimKey;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScopeKey)) {
            return false;
        }
        ScopeKey scopeKey = (ScopeKey)obj;
        return Objects.equals(this._objectClass, scopeKey.getObjectClass()) && Objects.equals(this._scope, scopeKey.getScope()) && Objects.equals(this._scopePrimKey, scopeKey.getScopePrimKey());
    }

    public Class<?> getObjectClass() {
        return this._objectClass;
    }

    public ExtendedObjectClassDefinition.Scope getScope() {
        return this._scope;
    }

    public String getScopePrimKey() {
        return this._scopePrimKey;
    }

    public int hashCode() {
        String s = StringBundler.concat((String[])new String[]{this._objectClass.getName(), this._scope.getValue(), this._scopePrimKey});
        return s.hashCode();
    }
}

