/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.settings.internal;

import com.liferay.portal.configuration.settings.internal.AnnotatedSettingsDescriptor;
import com.liferay.portal.configuration.settings.internal.ArchivedSettingsImpl;
import com.liferay.portal.configuration.settings.internal.ConfigurationBeanClassSettingsDescriptor;
import com.liferay.portal.configuration.settings.internal.util.ConfigurationPidUtil;
import com.liferay.portal.kernel.exception.NoSuchPortletItemException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PortletItemLocalService;
import com.liferay.portal.kernel.settings.ArchivedSettings;
import com.liferay.portal.kernel.settings.FallbackKeys;
import com.liferay.portal.kernel.settings.FallbackSettings;
import com.liferay.portal.kernel.settings.PortalSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsDescriptor;
import com.liferay.portal.kernel.settings.SettingsException;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocatorHelper;
import com.liferay.portal.kernel.settings.SettingsLocatorHelperUtil;
import com.liferay.portal.kernel.settings.definition.ConfigurationBeanDeclaration;
import com.liferay.portal.kernel.settings.definition.ConfigurationPidMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={SettingsFactory.class})
public class SettingsFactoryImpl
implements SettingsFactory {
    private static final Log _log = LogFactoryUtil.getLog(SettingsFactoryImpl.class);
    private final ConcurrentMap<String, FallbackKeys> _fallbackKeysMap = new ConcurrentHashMap<String, FallbackKeys>();
    private GroupLocalService _groupLocalService;
    private PortletItemLocalService _portletItemLocalService;
    private final Map<String, SettingsDescriptor> _settingsDescriptors = new ConcurrentHashMap<String, SettingsDescriptor>();

    public SettingsFactoryImpl() {
        this.registerSettingsMetadata(PortalSettings.class, null, null);
    }

    public ArchivedSettings getPortletInstanceArchivedSettings(long groupId, String portletId, String name) throws SettingsException {
        try {
            PortletItem portletItem = null;
            portletItem = this.getPortletItem(groupId, portletId, name);
            return new ArchivedSettingsImpl(portletItem);
        }
        catch (PortalException pe) {
            throw new SettingsException((Throwable)pe);
        }
    }

    public List<ArchivedSettings> getPortletInstanceArchivedSettingsList(long groupId, String portletId) {
        ArrayList<ArchivedSettings> archivedSettingsList = new ArrayList<ArchivedSettings>();
        List portletItems = this._portletItemLocalService.getPortletItems(groupId, portletId, com.liferay.portal.kernel.model.PortletPreferences.class.getName());
        for (PortletItem portletItem : portletItems) {
            archivedSettingsList.add(new ArchivedSettingsImpl(portletItem));
        }
        return archivedSettingsList;
    }

    @Deprecated
    public Settings getServerSettings(String settingsId) {
        SettingsLocatorHelper settingsLocatorHelper = SettingsLocatorHelperUtil.getSettingsLocatorHelper();
        return settingsLocatorHelper.getServerSettings(settingsId);
    }

    public Settings getSettings(SettingsLocator settingsLocator) throws SettingsException {
        Settings settings = settingsLocator.getSettings();
        return this.applyFallbackKeys(settingsLocator.getSettingsId(), settings);
    }

    public SettingsDescriptor getSettingsDescriptor(String settingsId) {
        settingsId = PortletIdCodec.decodePortletName((String)settingsId);
        return this._settingsDescriptors.get(settingsId);
    }

    public void registerSettingsMetadata(Class<?> settingsClass, Object configurationBean, FallbackKeys fallbackKeys) {
        AnnotatedSettingsDescriptor settingsDescriptor = new AnnotatedSettingsDescriptor(settingsClass);
        Settings.Config settingsConfig = settingsClass.getAnnotation(Settings.Config.class);
        for (String settingsId : settingsConfig.settingsIds()) {
            this.register(settingsId, settingsDescriptor, fallbackKeys);
        }
    }

    protected Settings applyFallbackKeys(String settingsId, Settings settings) {
        if (settings instanceof FallbackKeys) {
            return settings;
        }
        FallbackKeys fallbackKeys = (FallbackKeys)this._fallbackKeysMap.get(settingsId = PortletIdCodec.decodePortletName((String)settingsId));
        if (fallbackKeys != null) {
            settings = new FallbackSettings(settings, fallbackKeys);
        }
        return settings;
    }

    protected long getCompanyId(long groupId) throws SettingsException {
        try {
            Group group = this._groupLocalService.getGroup(groupId);
            return group.getCompanyId();
        }
        catch (PortalException pe) {
            throw new SettingsException((Throwable)pe);
        }
    }

    protected PortletItem getPortletItem(long groupId, String portletId, String name) throws PortalException {
        PortletItem portletItem = null;
        try {
            portletItem = this._portletItemLocalService.getPortletItem(groupId, name, portletId, PortletPreferences.class.getName());
        }
        catch (NoSuchPortletItemException nspie) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)nspie, (Throwable)nspie);
            }
            long userId = PrincipalThreadLocal.getUserId();
            portletItem = this._portletItemLocalService.updatePortletItem(userId, groupId, name, portletId, PortletPreferences.class.getName());
        }
        return portletItem;
    }

    protected void register(String settingsId, SettingsDescriptor settingsDescriptor, FallbackKeys fallbackKeys) {
        this._settingsDescriptors.put(settingsId, settingsDescriptor);
        if (fallbackKeys != null) {
            this._fallbackKeysMap.put(settingsId, fallbackKeys);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigurationBeanDeclaration(ConfigurationBeanDeclaration configurationBeanDeclaration) {
        Class configurationBeanClass = configurationBeanDeclaration.getConfigurationBeanClass();
        String settingsId = ConfigurationPidUtil.getConfigurationPid(configurationBeanClass);
        ConfigurationBeanClassSettingsDescriptor configurationBeanClassSettingsDescriptor = new ConfigurationBeanClassSettingsDescriptor(configurationBeanClass);
        this.register(settingsId, configurationBeanClassSettingsDescriptor, null);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setConfigurationPidMapping(ConfigurationPidMapping configurationPidMapping) {
        String settingsId = configurationPidMapping.getConfigurationPid();
        Class configurationBeanClass = configurationPidMapping.getConfigurationBeanClass();
        ConfigurationBeanClassSettingsDescriptor configurationBeanClassSettingsDescriptor = new ConfigurationBeanClassSettingsDescriptor(configurationBeanClass);
        this.register(settingsId, configurationBeanClassSettingsDescriptor, null);
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setPortletItemLocalService(PortletItemLocalService portletItemLocalService) {
        this._portletItemLocalService = portletItemLocalService;
    }

    protected void unregister(String settingsId) {
        this._fallbackKeysMap.remove(settingsId);
        this._settingsDescriptors.remove(settingsId);
    }

    protected void unsetConfigurationBeanDeclaration(ConfigurationBeanDeclaration configurationBeanDeclaration) {
        Class configurationBeanClass = configurationBeanDeclaration.getConfigurationBeanClass();
        String settingsId = ConfigurationPidUtil.getConfigurationPid(configurationBeanClass);
        this.unregister(settingsId);
    }

    protected void unsetConfigurationPidMapping(ConfigurationPidMapping configurationPidMapping) {
        this.unregister(configurationPidMapping.getConfigurationPid());
    }
}

