/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.persistence.internal.upgrade.v1_0_3;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Dictionary;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigurationUpgradeProcess
extends UpgradeProcess {
    private static final String _FILTER_KEY = "application.ready.service.filter";
    private static final String _FILTER_VALUE = "(liferay.jaxrs.whiteboard.ready=true)";
    private static final String _PID = "org.apache.aries.jax.rs.whiteboard.default";
    private final ConfigurationAdmin _configurationAdmin;

    public ConfigurationUpgradeProcess(ConfigurationAdmin configurationAdmin) {
        this._configurationAdmin = configurationAdmin;
    }

    protected void doUpgrade() throws Exception {
        if (!this.hasTable("Configuration_")) {
            return;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select * from Configuration_ where configurationId = ?");){
            preparedStatement.setString(1, _PID);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    Dictionary dictionary;
                    String dictionaryString = resultSet.getString("dictionary");
                    if (Validator.isNull((String)dictionaryString) || _FILTER_VALUE.equals((dictionary = ConfigurationHandler.read((InputStream)new UnsyncByteArrayInputStream(dictionaryString.getBytes("UTF-8")))).get(_FILTER_KEY))) continue;
                    dictionary.put(_FILTER_KEY, _FILTER_VALUE);
                    Configuration configuration = this._configurationAdmin.getConfiguration(_PID, "?");
                    configuration.update(dictionary);
                }
            }
        }
    }
}

