/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.persistence.internal.upgrade.release;

import com.liferay.portal.db.DBResourceUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.upgrade.release.SchemaCreator;
import java.sql.Connection;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={SchemaCreator.class})
public class ConfigurationSchemaCreator
implements SchemaCreator {
    private Bundle _bundle;

    public void create() throws UpgradeException {
        try (Connection connection = DataAccess.getConnection();){
            DBInspector dbInspector = new DBInspector(connection);
            if (dbInspector.hasTable("Configuration_")) {
                return;
            }
            DB db = DBManagerUtil.getDB();
            String tablesSQL = DBResourceUtil.getModuleTablesSQL((Bundle)this._bundle);
            db.runSQLTemplate(connection, tablesSQL, false);
        }
        catch (Exception exception) {
            throw new UpgradeException((Throwable)exception);
        }
    }

    public void create(Bundle bundle) throws UpgradeException {
        this._bundle = bundle;
        this.create();
    }

    public String getBundleSymbolicName() {
        return this._bundle.getSymbolicName();
    }

    public String getSchemaVersion() {
        Dictionary headers = this._bundle.getHeaders("");
        return GetterUtil.getString((String)((String)headers.get("Liferay-Require-SchemaVersion")), (String)"1.0.0");
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundle = bundleContext.getBundle();
    }
}

