/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.persistence.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.configuration.persistence.ConfigurationOverridePropertiesUtil;
import com.liferay.portal.configuration.persistence.InMemoryOnlyConfigurationThreadLocal;
import com.liferay.portal.configuration.persistence.ReloadablePersistenceManager;
import com.liferay.portal.configuration.persistence.internal.upgrade.release.ConfigurationSchemaCreator;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.db.partition.util.DBPartitionUtil;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.apache.felix.cm.NotCachablePersistenceManager;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ConfigurationPersistenceManager
implements NotCachablePersistenceManager,
PersistenceManager,
ReloadablePersistenceManager {
    private static final String _SERVICE_BUNDLE_LOCATION = "service.bundleLocation";
    private static final Log _log = LogFactoryUtil.getLog(ConfigurationPersistenceManager.class);
    private final BundleContext _bundleContext;
    private final DataSource _dataSource;
    private final DB _db = DBManagerUtil.getDB();
    private final ConcurrentMap<String, Dictionary<?, ?>> _dictionaries = new ConcurrentHashMap();
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock(true);
    private ServiceTrackerMap<String, List<ConfigurationModelListener>> _serviceTrackerMap;

    public ConfigurationPersistenceManager(BundleContext bundleContext, DataSource dataSource) {
        this._bundleContext = bundleContext;
        this._dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String pid) throws IOException {
        Dictionary<Object, Object> dictionary;
        String pidKey = null;
        if (!pid.endsWith("factory") && (dictionary = this._getDictionary(pid)) != null) {
            pidKey = (String)dictionary.get("service.factoryPid");
            if (pidKey == null) {
                pidKey = (String)dictionary.get("service.pid");
            }
            if (pidKey == null) {
                pidKey = pid;
            }
        }
        this._visitConfigurationModelListeners("*", (UnsafeConsumer<ConfigurationModelListener, ConfigurationModelListenerException>)((UnsafeConsumer)configurationModelListener -> configurationModelListener.onBeforeDelete(pid)));
        this._visitConfigurationModelListeners(pidKey, (UnsafeConsumer<ConfigurationModelListener, ConfigurationModelListenerException>)((UnsafeConsumer)configurationModelListener -> configurationModelListener.onBeforeDelete(pid)));
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            Dictionary dictionary2 = (Dictionary)this._dictionaries.remove(pid);
            if (dictionary2 != null) {
                this._deleteFromDatabase(pid);
            }
        }
        finally {
            lock.unlock();
        }
        this._visitConfigurationModelListeners("*", (UnsafeConsumer<ConfigurationModelListener, ConfigurationModelListenerException>)((UnsafeConsumer)configurationModelListener -> configurationModelListener.onAfterDelete(pid)));
        this._visitConfigurationModelListeners(pidKey, (UnsafeConsumer<ConfigurationModelListener, ConfigurationModelListenerException>)((UnsafeConsumer)configurationModelListener -> configurationModelListener.onAfterDelete(pid)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String pid) {
        Lock lock = this._readWriteLock.readLock();
        lock.lock();
        try {
            boolean bl = this._dictionaries.containsKey(pid);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public Enumeration<?> getDictionaries() {
        Lock lock = this._readWriteLock.readLock();
        lock.lock();
        try {
            Enumeration enumeration = Collections.enumeration(this._dictionaries.values());
            return enumeration;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary<?, ?> load(String pid) {
        Lock lock = this._readWriteLock.readLock();
        lock.lock();
        try {
            Dictionary dictionary = (Dictionary)this._dictionaries.get(pid);
            return dictionary;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String pid) throws IOException {
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            Dictionary<Object, Object> dictionary = this._overrideDictionary(pid, this._getDictionary(pid));
            if (dictionary == null) {
                this._dictionaries.remove(pid);
            } else {
                this._dictionaries.put(pid, dictionary);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void start() {
        block4: {
            try {
                if (!StartupHelperUtil.isDBNew()) {
                    this._populateDictionaries();
                    return;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Throwable)exception);
            }
        }
        this._createConfigurationTable();
        for (Bundle bundle : this._bundleContext.getBundles()) {
            if (!Objects.equals(bundle.getSymbolicName(), "org.apache.felix.configurator")) continue;
            File stateFile = bundle.getDataFile("state.ser");
            if (!stateFile.exists()) break;
            stateFile.delete();
            break;
        }
    }

    public void stop() {
        this._dictionaries.clear();
        if (this._serviceTrackerMap != null) {
            this._serviceTrackerMap.close();
            this._serviceTrackerMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String pid, Dictionary dictionary) throws IOException {
        String pidKey = null;
        if (!pid.endsWith("factory") && dictionary.get("_felix_.cm.newConfiguration") == null) {
            pidKey = (String)dictionary.get("service.factoryPid");
            if (pidKey == null) {
                pidKey = pid;
            }
            if (pidKey.endsWith(".scoped")) {
                pidKey = StringUtil.replaceLast((String)pidKey, (String)".scoped", (String)"");
            }
        }
        this._visitConfigurationModelListeners("*", (UnsafeConsumer<ConfigurationModelListener, ConfigurationModelListenerException>)((UnsafeConsumer)configurationModelListener -> configurationModelListener.onBeforeSave(pid, dictionary)));
        this._visitConfigurationModelListeners(pidKey, (UnsafeConsumer<ConfigurationModelListener, ConfigurationModelListenerException>)((UnsafeConsumer)configurationModelListener -> configurationModelListener.onBeforeSave(pid, dictionary)));
        Dictionary<Object, Object> newDictionary = this._copyDictionary(dictionary);
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            if (!InMemoryOnlyConfigurationThreadLocal.isInMemoryOnly()) {
                this._storeInDatabase(pid, newDictionary);
            }
            this._dictionaries.put(pid, this._overrideDictionary(pid, newDictionary));
        }
        finally {
            lock.unlock();
        }
        this._visitConfigurationModelListeners("*", (UnsafeConsumer<ConfigurationModelListener, ConfigurationModelListenerException>)((UnsafeConsumer)configurationModelListener -> configurationModelListener.onAfterSave(pid, dictionary)));
        this._visitConfigurationModelListeners(pidKey, (UnsafeConsumer<ConfigurationModelListener, ConfigurationModelListenerException>)((UnsafeConsumer)configurationModelListener -> configurationModelListener.onAfterSave(pid, dictionary)));
    }

    protected void store(ResultSet resultSet, Dictionary<?, ?> dictionary) throws IOException, SQLException {
        UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
        ConfigurationHandler.write((OutputStream)outputStream, dictionary);
        resultSet.updateString(2, outputStream.toString());
    }

    private Dictionary<Object, Object> _copyDictionary(Dictionary<?, ?> dictionary) {
        HashMapDictionary newDictionary = new HashMapDictionary();
        Enumeration<?> enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            newDictionary.put(key, dictionary.get(key));
        }
        return newDictionary;
    }

    private void _createConfigurationTable() {
        ConfigurationSchemaCreator configurationSchemaCreator = new ConfigurationSchemaCreator();
        try {
            configurationSchemaCreator.create(this._bundleContext.getBundle());
        }
        catch (Exception exception) {
            ReflectionUtil.throwException((Throwable)exception);
        }
        Map overridePropertiesMap = ConfigurationOverridePropertiesUtil.getOverridePropertiesMap();
        overridePropertiesMap.forEach((key, value) -> {
            Dictionary cfr_ignored_0 = (Dictionary)this._dictionaries.put((String)key, (Dictionary<?, ?>)new HashMapDictionary(value));
        });
    }

    private void _deleteFromDatabase(String pid) throws IOException {
        try (Connection connection = this._dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this._db.buildSQL("delete from Configuration_ where configurationId = ?"));){
            preparedStatement.setString(1, pid);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sqlException) {
            throw new IOException(sqlException);
        }
    }

    /*
     * Exception decompiling
     */
    private Dictionary<Object, Object> _getDictionary(String pid) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean _insertConfiguration(Connection connection, String pid, String configuration) throws IOException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this._db.buildSQL("insert into Configuration_ (configurationId, dictionary) values (?, ?)"));){
            preparedStatement.setString(1, pid);
            preparedStatement.setString(2, configuration);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sqlException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)sqlException);
            }
            return false;
        }
        return true;
    }

    private Dictionary<Object, Object> _overrideDictionary(String pid, Dictionary<Object, Object> dictionary) {
        Map overrideProperties = ConfigurationOverridePropertiesUtil.getOverrideProperties((String)pid);
        if (overrideProperties != null) {
            if (dictionary == null) {
                dictionary = new HashMapDictionary();
            }
            for (Map.Entry entry : overrideProperties.entrySet()) {
                dictionary.put(entry.getKey(), entry.getValue());
            }
        }
        return dictionary;
    }

    private void _populateDictionaries() throws Exception {
        HashMap<String, Map> overridePropertiesMap = new HashMap<String, Map>(ConfigurationOverridePropertiesUtil.getOverridePropertiesMap());
        DBPartitionUtil.forEachCompanyId(companyId -> {
            try (Connection connection = this._dataSource.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(this._db.buildSQL("select configurationId, dictionary from Configuration_"), 1003, 1007);
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String pid = resultSet.getString(1);
                    Dictionary<Object, Object> dictionary = this._verifyDictionary(pid, resultSet.getString(2));
                    if (dictionary == null) continue;
                    overridePropertiesMap.remove(pid);
                    this._dictionaries.put(pid, this._overrideDictionary(pid, dictionary));
                }
            }
        });
        overridePropertiesMap.forEach((key, value) -> {
            Dictionary cfr_ignored_0 = (Dictionary)this._dictionaries.put((String)key, (Dictionary<?, ?>)new HashMapDictionary(value));
        });
    }

    private void _storeInDatabase(String pid, Dictionary<?, ?> dictionary) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        ConfigurationHandler.write((OutputStream)unsyncByteArrayOutputStream, dictionary);
        String configuration = unsyncByteArrayOutputStream.toString();
        try (Connection connection = this._dataSource.getConnection();){
            if (this._dictionaries.containsKey(pid)) {
                if (!this._updateConfiguration(connection, pid, configuration)) {
                    this._insertConfiguration(connection, pid, configuration);
                }
            } else if (!this._insertConfiguration(connection, pid, configuration)) {
                this._updateConfiguration(connection, pid, configuration);
            }
        }
        catch (SQLException sqlException) {
            ReflectionUtil.throwException((Throwable)sqlException);
        }
    }

    private boolean _updateConfiguration(Connection connection, String pid, String configuration) throws IOException, SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this._db.buildSQL("update Configuration_ set dictionary = ? where configurationId = ?"));){
            preparedStatement.setString(1, configuration);
            preparedStatement.setString(2, pid);
            if (preparedStatement.executeUpdate() == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private Dictionary<Object, Object> _verifyDictionary(String pid, String dictionaryString) throws IOException {
        String ignore;
        if (dictionaryString == null) {
            return new HashMapDictionary();
        }
        Dictionary dictionary = ConfigurationHandler.read((InputStream)new UnsyncByteArrayInputStream(dictionaryString.getBytes("UTF-8")));
        String felixFileInstallFileName = (String)dictionary.get("felix.fileinstall.filename");
        if (felixFileInstallFileName == null) {
            return dictionary;
        }
        boolean needSave = false;
        if (dictionary.get(_SERVICE_BUNDLE_LOCATION) == null) {
            dictionary.put(_SERVICE_BUNDLE_LOCATION, "?");
            needSave = true;
        }
        File configFile = null;
        if (felixFileInstallFileName.startsWith("file:")) {
            try {
                configFile = new File(URI.create(felixFileInstallFileName));
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                configFile = new File(felixFileInstallFileName);
            }
            dictionary.put("felix.fileinstall.filename", configFile.getName());
            this._storeInDatabase(pid, dictionary);
            needSave = false;
        } else {
            configFile = new File(PropsValues.MODULE_FRAMEWORK_CONFIGS_DIR, felixFileInstallFileName);
        }
        if (needSave) {
            this._storeInDatabase(pid, dictionary);
        }
        if (!Boolean.valueOf(ignore = (String)dictionary.get("configuration.cleaner.ignore")).booleanValue() && !configFile.exists()) {
            this._deleteFromDatabase(pid);
            return null;
        }
        return dictionary;
    }

    private void _visitConfigurationModelListeners(String key, UnsafeConsumer<ConfigurationModelListener, ConfigurationModelListenerException> configurationModelListenerUnsafeConsumer) throws ConfigurationModelListenerException {
        if (Validator.isNull((String)key)) {
            return;
        }
        if (this._serviceTrackerMap == null) {
            this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)this._bundleContext, ConfigurationModelListener.class, (String)"model.class.name");
        }
        if (this._serviceTrackerMap.containsKey((Object)key)) {
            UnsafeConsumer.accept((Collection)((Collection)this._serviceTrackerMap.getService((Object)key)), configurationModelListenerUnsafeConsumer, ConfigurationModelListenerException.class);
        }
    }
}

