/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.persistence.internal;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.persistence.ReloadablePersistenceManager;
import com.liferay.portal.configuration.persistence.internal.listener.ConfigurationModelListenerProvider;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.felix.cm.NotCachablePersistenceManager;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.file.ConfigurationHandler;

public class ConfigurationPersistenceManager
implements NotCachablePersistenceManager,
PersistenceManager,
ReloadablePersistenceManager {
    private static final String _FELIX_FILE_INSTALL_FILENAME = "felix.fileinstall.filename";
    private static final Dictionary<?, ?> _emptyDictionary = new HashMapDictionary();
    private DataSource _dataSource;
    private final ConcurrentMap<String, Dictionary<?, ?>> _dictionaries = new ConcurrentHashMap();
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock(true);

    public void delete(final String pid) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        ConfigurationPersistenceManager.this.doDelete(pid);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        } else {
            this.doDelete(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String pid) {
        Lock lock = this._readWriteLock.readLock();
        try {
            lock.lock();
            boolean bl = this._dictionaries.containsKey(pid);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public Enumeration<?> getDictionaries() {
        Lock lock = this._readWriteLock.readLock();
        try {
            lock.lock();
            Enumeration enumeration = Collections.enumeration(this._dictionaries.values());
            return enumeration;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary<?, ?> load(String pid) {
        Lock lock = this._readWriteLock.readLock();
        try {
            lock.lock();
            Dictionary dictionary = (Dictionary)this._dictionaries.get(pid);
            return dictionary;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String pid) throws IOException {
        Lock lock = this._readWriteLock.writeLock();
        try {
            lock.lock();
            this._dictionaries.remove(pid);
            if (this.hasPid(pid)) {
                Dictionary<?, ?> dictionary = this.getDictionary(pid);
                this._dictionaries.put(pid, dictionary);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Lock readLock = this._readWriteLock.readLock();
        Lock writeLock = this._readWriteLock.writeLock();
        try {
            readLock.lock();
            if (this.hasConfigurationTable()) {
                readLock.unlock();
                writeLock.lock();
                try {
                    this._verifyConfigurations();
                }
                finally {
                    readLock.lock();
                    writeLock.unlock();
                }
            }
            readLock.unlock();
            writeLock.lock();
            try {
                this.createConfigurationTable();
            }
            finally {
                readLock.lock();
                writeLock.unlock();
            }
            this.populateDictionaries();
        }
        finally {
            readLock.unlock();
        }
    }

    public void stop() {
        this._dictionaries.clear();
    }

    public void store(final String pid, final Dictionary dictionary) throws IOException {
        if (System.getSecurityManager() != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        ConfigurationPersistenceManager.this.doStore(pid, dictionary);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        } else {
            this.doStore(pid, dictionary);
        }
    }

    protected String buildSQL(String sql) throws IOException {
        DB db = DBManagerUtil.getDB();
        return db.buildSQL(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cleanUp(Connection connection, Statement statement, ResultSet resultSet) {
        try {
            if (resultSet == null) return;
            resultSet.close();
            return;
        }
        catch (SQLException sqle) {
            ReflectionUtil.throwException((Throwable)sqle);
            return;
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sqle) {
                ReflectionUtil.throwException((Throwable)sqle);
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sqle) {
                    ReflectionUtil.throwException((Throwable)sqle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createConfigurationTable() {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this._dataSource.getConnection();
            statement = connection.createStatement();
            statement.executeUpdate(this.buildSQL("create table Configuration_ (configurationId VARCHAR(255) not null primary key, dictionary TEXT)"));
        }
        catch (IOException | SQLException e) {
            ReflectionUtil.throwException((Throwable)e);
        }
        finally {
            this.cleanUp(connection, statement, resultSet);
        }
    }

    protected void deleteFromDatabase(String pid) throws IOException {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this._dataSource.getConnection();
            preparedStatement = this.prepareStatement(connection, "delete from Configuration_ where configurationId = ?");
            preparedStatement.setString(1, pid);
            preparedStatement.executeUpdate();
            this.cleanUp(connection, preparedStatement, null);
        }
        catch (SQLException sqle) {
            try {
                throw new IOException(sqle);
            }
            catch (Throwable throwable) {
                this.cleanUp(connection, preparedStatement, null);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete(String pid) throws IOException {
        ConfigurationModelListener configurationModelListener = null;
        if (!pid.endsWith("factory") && this.hasPid(pid)) {
            Dictionary<?, ?> dictionary = this.getDictionary(pid);
            String pidKey = (String)dictionary.get("service.factoryPid");
            if (pidKey == null) {
                pidKey = (String)dictionary.get("service.pid");
            }
            if (pidKey == null) {
                pidKey = pid;
            }
            configurationModelListener = ConfigurationModelListenerProvider.getConfigurationModelListener(pidKey);
        }
        if (configurationModelListener != null) {
            configurationModelListener.onBeforeDelete(pid);
        }
        Lock lock = this._readWriteLock.writeLock();
        try {
            lock.lock();
            Dictionary dictionary = (Dictionary)this._dictionaries.remove(pid);
            if (dictionary != null && this.hasPid(pid)) {
                this.deleteFromDatabase(pid);
            }
        }
        finally {
            lock.unlock();
        }
        if (configurationModelListener != null) {
            configurationModelListener.onAfterDelete(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStore(String pid, Dictionary dictionary) throws IOException {
        Dictionary<Object, Object> newDictionary;
        String fileName;
        ConfigurationModelListener configurationModelListener = null;
        if (!pid.endsWith("factory") && dictionary.get("_felix_.cm.newConfiguration") == null) {
            String pidKey = (String)dictionary.get("service.factoryPid");
            if (pidKey == null) {
                pidKey = pid;
            }
            configurationModelListener = ConfigurationModelListenerProvider.getConfigurationModelListener(pidKey);
        }
        if (configurationModelListener != null) {
            configurationModelListener.onBeforeSave(pid, dictionary);
        }
        if ((fileName = (String)(newDictionary = this._copyDictionary(dictionary)).get(_FELIX_FILE_INSTALL_FILENAME)) != null) {
            File file = new File(URI.create(fileName));
            newDictionary.put(_FELIX_FILE_INSTALL_FILENAME, file.getName());
        }
        Lock lock = this._readWriteLock.writeLock();
        try {
            lock.lock();
            this.storeInDatabase(pid, newDictionary);
            if (fileName != null) {
                newDictionary.put(_FELIX_FILE_INSTALL_FILENAME, fileName);
            }
            this._dictionaries.put(pid, newDictionary);
        }
        finally {
            lock.unlock();
        }
        if (configurationModelListener != null) {
            configurationModelListener.onAfterSave(pid, dictionary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dictionary<?, ?> getDictionary(String pid) throws IOException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block5: {
            connection = null;
            preparedStatement = null;
            resultSet = null;
            connection = this._dataSource.getConnection();
            preparedStatement = this.prepareStatement(connection, "select dictionary from Configuration_ where configurationId = ?");
            preparedStatement.setString(1, pid);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            Dictionary<?, ?> dictionary = this.toDictionary(resultSet.getString(1));
            this.cleanUp(connection, preparedStatement, resultSet);
            return dictionary;
        }
        try {
            Dictionary<?, ?> dictionary = _emptyDictionary;
            this.cleanUp(connection, preparedStatement, resultSet);
            return dictionary;
        }
        catch (SQLException sqle) {
            try {
                Dictionary dictionary = (Dictionary)ReflectionUtil.throwException((Throwable)sqle);
                this.cleanUp(connection, preparedStatement, resultSet);
                return dictionary;
            }
            catch (Throwable throwable) {
                this.cleanUp(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasConfigurationTable() {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block6: {
            connection = null;
            preparedStatement = null;
            resultSet = null;
            connection = this._dataSource.getConnection();
            preparedStatement = this.prepareStatement(connection, "select count(*) from Configuration_");
            resultSet = preparedStatement.executeQuery();
            int count = 0;
            if (resultSet.next()) {
                count = resultSet.getInt(1);
            }
            if (count < 0) break block6;
            boolean bl = true;
            this.cleanUp(connection, preparedStatement, resultSet);
            return bl;
        }
        try {
            boolean bl = false;
            this.cleanUp(connection, preparedStatement, resultSet);
            return bl;
        }
        catch (IOException | SQLException e) {
            try {
                boolean bl = false;
                this.cleanUp(connection, preparedStatement, resultSet);
                return bl;
            }
            catch (Throwable throwable) {
                this.cleanUp(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasPid(String pid) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block6: {
            connection = null;
            preparedStatement = null;
            resultSet = null;
            connection = this._dataSource.getConnection();
            preparedStatement = this.prepareStatement(connection, "select count(*) from Configuration_ where configurationId = ?");
            preparedStatement.setString(1, pid);
            resultSet = preparedStatement.executeQuery();
            int count = 0;
            if (resultSet.next()) {
                count = resultSet.getInt(1);
            }
            if (count <= 0) break block6;
            boolean bl = true;
            this.cleanUp(connection, preparedStatement, resultSet);
            return bl;
        }
        try {
            boolean bl = false;
            this.cleanUp(connection, preparedStatement, resultSet);
            return bl;
        }
        catch (IOException | SQLException e) {
            try {
                boolean bl = (Boolean)ReflectionUtil.throwException((Throwable)e);
                this.cleanUp(connection, preparedStatement, resultSet);
                return bl;
            }
            catch (Throwable throwable) {
                this.cleanUp(connection, preparedStatement, resultSet);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateDictionaries() {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = this._dataSource.getConnection();
            preparedStatement = connection.prepareStatement(this.buildSQL("select configurationId, dictionary from Configuration_ ORDER BY configurationId ASC"), 1003, 1007);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String pid = resultSet.getString(1);
                String dictionaryString = resultSet.getString(2);
                this._dictionaries.putIfAbsent(pid, this.toDictionary(dictionaryString));
            }
            this.cleanUp(connection, preparedStatement, resultSet);
        }
        catch (IOException | SQLException e) {
            ReflectionUtil.throwException((Throwable)e);
        }
        finally {
            this.cleanUp(connection, preparedStatement, resultSet);
        }
    }

    protected PreparedStatement prepareStatement(Connection connection, String sql) throws IOException, SQLException {
        return connection.prepareStatement(this.buildSQL(sql));
    }

    protected void store(ResultSet resultSet, Dictionary<?, ?> dictionary) throws IOException, SQLException {
        UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
        ConfigurationHandler.write((OutputStream)outputStream, dictionary);
        resultSet.updateString(2, outputStream.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeInDatabase(String pid, Dictionary<?, ?> dictionary) throws IOException {
        block6: {
            UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
            ConfigurationHandler.write((OutputStream)outputStream, dictionary);
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                connection = this._dataSource.getConnection();
                connection.setAutoCommit(false);
                preparedStatement = connection.prepareStatement(this.buildSQL("update Configuration_ set dictionary = ? where configurationId = ?"));
                preparedStatement.setString(1, outputStream.toString());
                preparedStatement.setString(2, pid);
                if (preparedStatement.executeUpdate() == 0) {
                    preparedStatement = this.prepareStatement(connection, "insert into Configuration_ (configurationId, dictionary) values (?, ?)");
                    preparedStatement.setString(1, pid);
                    preparedStatement.setString(2, outputStream.toString());
                    preparedStatement.executeUpdate();
                }
                connection.commit();
                this.cleanUp(connection, preparedStatement, resultSet);
            }
            catch (SQLException sqle) {
                ReflectionUtil.throwException((Throwable)sqle);
                break block6;
            }
            finally {
                this.cleanUp(connection, preparedStatement, resultSet);
                outputStream.close();
            }
            outputStream.close();
        }
    }

    protected Dictionary<?, ?> toDictionary(String dictionaryString) throws IOException {
        if (dictionaryString == null) {
            return new HashMapDictionary();
        }
        Dictionary dictionary = ConfigurationHandler.read((InputStream)new UnsyncByteArrayInputStream(dictionaryString.getBytes("UTF-8")));
        String fileName = (String)dictionary.get(_FELIX_FILE_INSTALL_FILENAME);
        if (fileName != null) {
            File file = new File(PropsValues.MODULE_FRAMEWORK_CONFIGS_DIR, fileName);
            file = file.getAbsoluteFile();
            URI uri = file.toURI();
            dictionary.put(_FELIX_FILE_INSTALL_FILENAME, uri.toString());
        }
        return dictionary;
    }

    private Dictionary<Object, Object> _copyDictionary(Dictionary<?, ?> dictionary) {
        HashMapDictionary newDictionary = new HashMapDictionary();
        Enumeration<?> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            newDictionary.put(key, dictionary.get(key));
        }
        return newDictionary;
    }

    private void _verifyConfigurations() {
        this._verifyConfigurationsBundleLocation();
        this._verifyConfigurationsFileName();
    }

    private void _verifyConfigurations(String sql, Consumer<Dictionary<Object, Object>> dictionaryConsumer) {
        try (Connection connection = this._dataSource.getConnection();
             PreparedStatement selectPS = connection.prepareStatement(this.buildSQL(sql));
             PreparedStatement updatePS = connection.prepareStatement(this.buildSQL("update Configuration_ set dictionary = ? where configurationId = ?"));
             ResultSet rs = selectPS.executeQuery();){
            while (rs.next()) {
                String pid = rs.getString(1);
                String dictionaryString = rs.getString(2);
                Dictionary dictionary = ConfigurationHandler.read((InputStream)new UnsyncByteArrayInputStream(dictionaryString.getBytes("UTF-8")));
                dictionaryConsumer.accept(dictionary);
                UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                ConfigurationHandler.write((OutputStream)unsyncByteArrayOutputStream, (Dictionary)dictionary);
                updatePS.setString(1, unsyncByteArrayOutputStream.toString());
                updatePS.setString(2, pid);
                updatePS.executeUpdate();
            }
        }
        catch (Exception e) {
            ReflectionUtil.throwException((Throwable)e);
        }
    }

    private void _verifyConfigurationsBundleLocation() {
        this._verifyConfigurations(StringBundler.concat((String[])new String[]{"select configurationId, dictionary from Configuration_ where ", "dictionary like '%felix.fileinstall.filename=%' and ", "dictionary not like '%", "service.bundleLocation", "=\"%'"}), dictionary -> dictionary.put("service.bundleLocation", "?"));
    }

    private void _verifyConfigurationsFileName() {
        this._verifyConfigurations(StringBundler.concat((String[])new String[]{"select configurationId, dictionary from Configuration_ where ", "dictionary like '%", _FELIX_FILE_INSTALL_FILENAME, "=\"file:%'"}), dictionary -> {
            String fileName = (String)dictionary.get(_FELIX_FILE_INSTALL_FILENAME);
            File file = new File(URI.create(fileName));
            dictionary.put(_FELIX_FILE_INSTALL_FILENAME, file.getName());
        });
    }
}

