/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.persistence.internal.upgrade;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.persistence.upgrade.ConfigurationUpgradeStepFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Dictionary;
import org.apache.felix.cm.PersistenceManager;

public class ConfigurationUpgradeStepFactoryImpl
implements ConfigurationUpgradeStepFactory {
    private static final Log _log = LogFactoryUtil.getLog(ConfigurationUpgradeStepFactoryImpl.class);
    private final PersistenceManager _persistenceManager;

    public ConfigurationUpgradeStepFactoryImpl(PersistenceManager persistenceManager) {
        this._persistenceManager = persistenceManager;
    }

    public UpgradeStep createUpgradeStep(String oldPid, String newPid) {
        return dbProcessContext -> {
            try {
                if (this._persistenceManager.exists(oldPid)) {
                    Dictionary dictionary = this._persistenceManager.load(oldPid);
                    dictionary.remove("service.pid");
                    dictionary.put("service.pid", newPid);
                    this._persistenceManager.store(newPid, dictionary);
                    this._persistenceManager.delete(oldPid);
                }
                this._renameConfigurationFile(oldPid, newPid, "cfg");
                this._renameConfigurationFile(oldPid, newPid, "config");
            }
            catch (IOException ioException) {
                throw new UpgradeException((Throwable)ioException);
            }
        };
    }

    private void _renameConfigurationFile(String oldPid, String newPid, String extension) throws IOException {
        File oldConfigFile = new File(StringBundler.concat((String[])new String[]{PropsValues.MODULE_FRAMEWORK_CONFIGS_DIR, "/", oldPid, ".", extension}));
        if (!oldConfigFile.exists()) {
            return;
        }
        File newConfigFile = new File(StringBundler.concat((String[])new String[]{PropsValues.MODULE_FRAMEWORK_CONFIGS_DIR, "/", newPid, ".", extension}));
        if (newConfigFile.exists()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to rename ", oldConfigFile.getAbsolutePath(), " to ", newConfigFile.getAbsolutePath(), " because the file already exists"}));
            }
            return;
        }
        Files.move(oldConfigFile.toPath(), newConfigFile.toPath(), new CopyOption[0]);
    }
}

