/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.persistence.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.configuration.persistence.ConfigurationOverridePropertiesUtil;
import com.liferay.portal.configuration.persistence.ReloadablePersistenceManager;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import org.apache.felix.cm.NotCachablePersistenceManager;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.osgi.framework.BundleContext;

public class ConfigurationPersistenceManager
implements NotCachablePersistenceManager,
PersistenceManager,
ReloadablePersistenceManager {
    private static final String _FELIX_FILE_INSTALL_FILENAME = "felix.fileinstall.filename";
    private static final String _SERVIE_BUNDLE_LOCATION = "service.bundleLocation";
    private final BundleContext _bundleContext;
    private final DataSource _dataSource;
    private final DB _db = DBManagerUtil.getDB();
    private final ConcurrentMap<String, Dictionary<?, ?>> _dictionaries = new ConcurrentHashMap();
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock(true);
    private ServiceTrackerMap<String, ConfigurationModelListener> _serviceTrackerMap;

    public ConfigurationPersistenceManager(BundleContext bundleContext, DataSource dataSource) {
        this._bundleContext = bundleContext;
        this._dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String pid) throws IOException {
        Dictionary<Object, Object> dictionary;
        ConfigurationModelListener configurationModelListener = null;
        if (!pid.endsWith("factory") && (dictionary = this.getDictionary(pid)) != null) {
            String pidKey = (String)dictionary.get("service.factoryPid");
            if (pidKey == null) {
                pidKey = (String)dictionary.get("service.pid");
            }
            if (pidKey == null) {
                pidKey = pid;
            }
            configurationModelListener = this._getConfigurationModelListener(pidKey);
        }
        if (configurationModelListener != null) {
            configurationModelListener.onBeforeDelete(pid);
        }
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            Dictionary dictionary2 = (Dictionary)this._dictionaries.remove(pid);
            if (dictionary2 != null) {
                this.deleteFromDatabase(pid);
            }
        }
        finally {
            lock.unlock();
        }
        if (configurationModelListener != null) {
            configurationModelListener.onAfterDelete(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String pid) {
        Lock lock = this._readWriteLock.readLock();
        lock.lock();
        try {
            boolean bl = this._dictionaries.containsKey(pid);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public Enumeration<?> getDictionaries() {
        Lock lock = this._readWriteLock.readLock();
        lock.lock();
        try {
            Enumeration enumeration = Collections.enumeration(this._dictionaries.values());
            return enumeration;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dictionary<?, ?> load(String pid) {
        Lock lock = this._readWriteLock.readLock();
        lock.lock();
        try {
            Dictionary dictionary = (Dictionary)this._dictionaries.get(pid);
            return dictionary;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String pid) throws IOException {
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            Dictionary<Object, Object> dictionary = this._overrideDictionary(pid, this.getDictionary(pid));
            if (dictionary == null) {
                this._dictionaries.remove(pid);
            } else {
                this._dictionaries.put(pid, dictionary);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void start() {
        try {
            this.createConfigurationTable();
        }
        catch (IOException | SQLException exception) {
            this.populateDictionaries();
        }
    }

    public void stop() {
        this._dictionaries.clear();
        if (this._serviceTrackerMap != null) {
            this._serviceTrackerMap.close();
            this._serviceTrackerMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String pid, Dictionary dictionary) throws IOException {
        Dictionary<Object, Object> newDictionary;
        String fileName;
        ConfigurationModelListener configurationModelListener = null;
        if (!pid.endsWith("factory") && dictionary.get("_felix_.cm.newConfiguration") == null) {
            String pidKey = (String)dictionary.get("service.factoryPid");
            if (pidKey == null) {
                pidKey = pid;
            }
            configurationModelListener = this._getConfigurationModelListener(pidKey);
        }
        if (configurationModelListener != null) {
            configurationModelListener.onBeforeSave(pid, dictionary);
        }
        if ((fileName = (String)(newDictionary = this._copyDictionary(dictionary)).get(_FELIX_FILE_INSTALL_FILENAME)) != null) {
            File file = new File(URI.create(fileName));
            newDictionary.put(_FELIX_FILE_INSTALL_FILENAME, file.getName());
        }
        Lock lock = this._readWriteLock.writeLock();
        lock.lock();
        try {
            this.storeInDatabase(pid, newDictionary);
            if (fileName != null) {
                newDictionary.put(_FELIX_FILE_INSTALL_FILENAME, fileName);
            }
            this._dictionaries.put(pid, this._overrideDictionary(pid, newDictionary));
        }
        finally {
            lock.unlock();
        }
        if (configurationModelListener != null) {
            configurationModelListener.onAfterSave(pid, dictionary);
        }
    }

    protected void createConfigurationTable() throws IOException, SQLException {
        try (Connection connection = this._dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate(this._db.buildSQL("create table Configuration_ (configurationId VARCHAR(255) not null primary key, dictionary TEXT)"));
        }
        Map overridePropertiesMap = ConfigurationOverridePropertiesUtil.getOverridePropertiesMap();
        overridePropertiesMap.forEach((key, value) -> {
            Dictionary cfr_ignored_0 = (Dictionary)this._dictionaries.put((String)key, (Dictionary<?, ?>)new HashMapDictionary(value));
        });
    }

    protected void deleteFromDatabase(String pid) throws IOException {
        try (Connection connection = this._dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this._db.buildSQL("delete from Configuration_ where configurationId = ?"));){
            preparedStatement.setString(1, pid);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sqlException) {
            throw new IOException(sqlException);
        }
    }

    /*
     * Exception decompiling
     */
    protected Dictionary<Object, Object> getDictionary(String pid) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void populateDictionaries() {
        HashMap<String, Map> overridePropertiesMap = new HashMap<String, Map>(ConfigurationOverridePropertiesUtil.getOverridePropertiesMap());
        try (Connection connection = this._dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this._db.buildSQL("select configurationId, dictionary from Configuration_"), 1003, 1007);
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String pid = resultSet.getString(1);
                Dictionary<Object, Object> dictionary = this._verifyDictionary(pid, resultSet.getString(2));
                if (dictionary == null) continue;
                overridePropertiesMap.remove(pid);
                this._dictionaries.put(pid, this._overrideDictionary(pid, dictionary));
            }
        }
        catch (IOException | SQLException exception) {
            ReflectionUtil.throwException((Throwable)exception);
        }
        overridePropertiesMap.forEach((key, value) -> {
            Dictionary cfr_ignored_0 = (Dictionary)this._dictionaries.put((String)key, (Dictionary<?, ?>)new HashMapDictionary(value));
        });
    }

    protected void store(ResultSet resultSet, Dictionary<?, ?> dictionary) throws IOException, SQLException {
        UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
        ConfigurationHandler.write((OutputStream)outputStream, dictionary);
        resultSet.updateString(2, outputStream.toString());
    }

    protected void storeInDatabase(String pid, Dictionary<?, ?> dictionary) throws IOException {
        UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
        ConfigurationHandler.write((OutputStream)outputStream, dictionary);
        try (Connection connection = this._dataSource.getConnection();){
            block38: {
                connection.setAutoCommit(false);
                try (PreparedStatement ps1 = connection.prepareStatement(this._db.buildSQL("update Configuration_ set dictionary = ? where configurationId = ?"));){
                    ps1.setString(1, outputStream.toString());
                    ps1.setString(2, pid);
                    if (ps1.executeUpdate() != 0) break block38;
                    try (PreparedStatement ps2 = connection.prepareStatement(this._db.buildSQL("insert into Configuration_ (configurationId, dictionary) values (?, ?)"));){
                        ps2.setString(1, pid);
                        ps2.setString(2, outputStream.toString());
                        ps2.executeUpdate();
                    }
                }
            }
            connection.commit();
        }
        catch (SQLException sqlException) {
            ReflectionUtil.throwException((Throwable)sqlException);
        }
    }

    protected Dictionary<Object, Object> toDictionary(String dictionaryString) throws IOException {
        if (dictionaryString == null) {
            return new HashMapDictionary();
        }
        Dictionary dictionary = ConfigurationHandler.read((InputStream)new UnsyncByteArrayInputStream(dictionaryString.getBytes("UTF-8")));
        String fileName = (String)dictionary.get(_FELIX_FILE_INSTALL_FILENAME);
        if (fileName != null) {
            File file = this._getCanonicalConfigFile(fileName);
            URI uri = file.toURI();
            dictionary.put(_FELIX_FILE_INSTALL_FILENAME, uri.toString());
        }
        return dictionary;
    }

    private Dictionary<Object, Object> _copyDictionary(Dictionary<?, ?> dictionary) {
        HashMapDictionary newDictionary = new HashMapDictionary();
        Enumeration<?> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            newDictionary.put(key, dictionary.get(key));
        }
        return newDictionary;
    }

    private File _getCanonicalConfigFile(String fileName) throws IOException {
        File configFile = new File(PropsValues.MODULE_FRAMEWORK_CONFIGS_DIR, fileName);
        return configFile.getCanonicalFile();
    }

    private ConfigurationModelListener _getConfigurationModelListener(String configurationModelClassName) {
        if (this._serviceTrackerMap == null) {
            this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)this._bundleContext, ConfigurationModelListener.class, (String)"model.class.name");
        }
        return (ConfigurationModelListener)this._serviceTrackerMap.getService((Object)configurationModelClassName);
    }

    private Dictionary<Object, Object> _overrideDictionary(String pid, Dictionary<Object, Object> dictionary) {
        Map overrideProperties = ConfigurationOverridePropertiesUtil.getOverrideProperties((String)pid);
        if (overrideProperties != null) {
            if (dictionary == null) {
                dictionary = new HashMapDictionary();
            }
            for (Map.Entry entry : overrideProperties.entrySet()) {
                dictionary.put(entry.getKey(), entry.getValue());
            }
        }
        return dictionary;
    }

    private Dictionary<Object, Object> _verifyDictionary(String pid, String dictionaryString) throws IOException {
        String ignore;
        if (dictionaryString == null) {
            return new HashMapDictionary();
        }
        Dictionary dictionary = ConfigurationHandler.read((InputStream)new UnsyncByteArrayInputStream(dictionaryString.getBytes("UTF-8")));
        String felixFileInstallFileName = (String)dictionary.get(_FELIX_FILE_INSTALL_FILENAME);
        if (felixFileInstallFileName == null) {
            return dictionary;
        }
        boolean needSave = false;
        if (dictionary.get(_SERVIE_BUNDLE_LOCATION) == null) {
            dictionary.put(_SERVIE_BUNDLE_LOCATION, "?");
            needSave = true;
        }
        File configFile = null;
        if (felixFileInstallFileName.startsWith("file:")) {
            try {
                configFile = new File(URI.create(felixFileInstallFileName));
            }
            catch (Exception exception) {
                configFile = new File(felixFileInstallFileName);
            }
            dictionary.put(_FELIX_FILE_INSTALL_FILENAME, configFile.getName());
            this.storeInDatabase(pid, dictionary);
            dictionary.put(_FELIX_FILE_INSTALL_FILENAME, felixFileInstallFileName);
            needSave = false;
        } else {
            configFile = this._getCanonicalConfigFile(felixFileInstallFileName);
            URI uri = configFile.toURI();
            dictionary.put(_FELIX_FILE_INSTALL_FILENAME, uri.toString());
        }
        if (needSave) {
            this.storeInDatabase(pid, dictionary);
        }
        if (!Boolean.valueOf(ignore = (String)dictionary.get("configuration.cleaner.ignore")).booleanValue() && !configFile.exists()) {
            this.deleteFromDatabase(pid);
            return null;
        }
        return dictionary;
    }
}

