/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.cluster.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.cluster.internal.ConfigurationThreadLocal;
import com.liferay.portal.configuration.persistence.InMemoryOnlyConfigurationThreadLocal;
import com.liferay.portal.configuration.persistence.ReloadablePersistenceManager;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Set;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.SynchronousConfigurationListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={SynchronousConfigurationListener.class})
public class ConfigurationSynchronousConfigurationListener
implements SynchronousConfigurationListener {
    private static final Log _log = LogFactoryUtil.getLog((String)ConfigurationSynchronousConfigurationListener.class.getName());
    private static final MethodKey _onNotifyMethodKey = new MethodKey(ConfigurationSynchronousConfigurationListener.class, "_onNotify", new Class[]{String.class, Integer.TYPE});
    private static final Snapshot<SynchronousConfigurationListener> _snapshot = new Snapshot(ConfigurationSynchronousConfigurationListener.class, SynchronousConfigurationListener.class, "(component.name=com.liferay.portal.configuration.cluster.internal.ConfigurationSynchronousConfigurationListener)", true);
    @Reference
    private ClusterExecutor _clusterExecutor;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ReloadablePersistenceManager _reloadablePersistenceManager;

    public void configurationEvent(ConfigurationEvent configurationEvent) {
        if (ConfigurationThreadLocal.isLocalUpdate() || InMemoryOnlyConfigurationThreadLocal.isInMemoryOnly()) {
            return;
        }
        try {
            MethodHandler methodHandler = new MethodHandler(_onNotifyMethodKey, new Object[]{configurationEvent.getPid(), configurationEvent.getType()});
            ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)methodHandler, (boolean)true);
            clusterRequest.setFireAndForget(true);
            this._clusterExecutor.execute(clusterRequest);
        }
        catch (Throwable throwable) {
            _log.error(throwable);
        }
    }

    private static void _onNotify(String pid, int type) throws Exception {
        SynchronousConfigurationListener synchronousConfigurationListener = (SynchronousConfigurationListener)_snapshot.get();
        if (synchronousConfigurationListener == null) {
            return;
        }
        ConfigurationSynchronousConfigurationListener configurationSynchronousConfigurationListener = (ConfigurationSynchronousConfigurationListener)synchronousConfigurationListener;
        configurationSynchronousConfigurationListener._reloadConfiguration(pid, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _reloadConfiguration(String pid, int type) throws Exception {
        this._reloadablePersistenceManager.reload(pid);
        Dictionary dictionary = this._reloadablePersistenceManager.load(pid);
        try {
            ConfigurationThreadLocal.setLocalUpdate(true);
            Configuration[] configurations = this._configurationAdmin.listConfigurations(StringBundler.concat((String[])new String[]{"(", "service.pid", "=", pid, ")"}));
            if (configurations == null) {
                return;
            }
            for (Configuration configuration : configurations) {
                Set configurationAttributes = configuration.getAttributes();
                boolean readOnly = false;
                if (configurationAttributes.contains(Configuration.ConfigurationAttribute.READ_ONLY)) {
                    configuration.removeAttributes(new Configuration.ConfigurationAttribute[]{Configuration.ConfigurationAttribute.READ_ONLY});
                    readOnly = true;
                }
                if (type == 2) {
                    configuration.delete();
                    continue;
                }
                if (dictionary == null) {
                    configuration.update();
                } else {
                    configuration.update(dictionary);
                }
                if (!readOnly) continue;
                configuration.addAttributes(new Configuration.ConfigurationAttribute[]{Configuration.ConfigurationAttribute.READ_ONLY});
            }
        }
        finally {
            ConfigurationThreadLocal.setLocalUpdate(false);
        }
    }
}

