/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.cluster.internal.messaging;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.cluster.internal.ConfigurationThreadLocal;
import com.liferay.portal.configuration.persistence.ReloadablePersistenceManager;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import java.util.Dictionary;
import java.util.Set;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"destination.name=liferay/configuration"}, service={MessageListener.class})
public class ConfigurationMessageListener
extends BaseMessageListener {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference(target="(destination.name=liferay/configuration)")
    private Destination _destination;
    @Reference
    private ReloadablePersistenceManager _reloadablePersistenceManager;

    protected void doReceive(Message message) throws Exception {
        this._reloadConfiguration(message.getString("service.pid"), message.getInteger("configuration.event.type"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _reloadConfiguration(String pid, int type) throws Exception {
        this._reloadablePersistenceManager.reload(pid);
        Dictionary dictionary = this._reloadablePersistenceManager.load(pid);
        try {
            ConfigurationThreadLocal.setLocalUpdate(true);
            Configuration[] configurations = this._configurationAdmin.listConfigurations(StringBundler.concat((String[])new String[]{"(", "service.pid", "=", pid, ")"}));
            if (configurations == null) {
                return;
            }
            for (Configuration configuration : configurations) {
                Set configurationAttributes = configuration.getAttributes();
                boolean readOnly = false;
                if (configurationAttributes.contains(Configuration.ConfigurationAttribute.READ_ONLY)) {
                    configuration.removeAttributes(new Configuration.ConfigurationAttribute[]{Configuration.ConfigurationAttribute.READ_ONLY});
                    readOnly = true;
                }
                if (type == 2) {
                    configuration.delete();
                    continue;
                }
                if (dictionary == null) {
                    configuration.update();
                } else {
                    configuration.update(dictionary);
                }
                if (!readOnly) continue;
                configuration.addAttributes(new Configuration.ConfigurationAttribute[]{Configuration.ConfigurationAttribute.READ_ONLY});
            }
        }
        finally {
            ConfigurationThreadLocal.setLocalUpdate(false);
        }
    }
}

