/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.cluster.internal.messaging;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.cluster.internal.ConfigurationThreadLocal;
import com.liferay.portal.configuration.persistence.ReloadablePersistenceManager;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import java.util.Dictionary;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"destination.name=liferay/configuration"}, service={MessageListener.class})
public class ConfigurationMessageListener
extends BaseMessageListener {
    private ConfigurationAdmin _configurationAdmin;
    private ReloadablePersistenceManager _reloadablePersistenceManager;

    @Reference(unbind="-")
    public void setReloadablePersistenceManager(ReloadablePersistenceManager reloadablePersistenceManager) {
        this._reloadablePersistenceManager = reloadablePersistenceManager;
    }

    protected void doReceive(Message message) throws Exception {
        this.reloadConfiguration(message.getString("service.pid"), message.getInteger("configuration.event.type"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadConfiguration(String pid, int type) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("(");
        sb.append("service.pid");
        sb.append("=");
        sb.append(pid);
        sb.append(")");
        this._reloadablePersistenceManager.reload(pid);
        Dictionary dictionary = this._reloadablePersistenceManager.load(pid);
        try {
            ConfigurationThreadLocal.setLocalUpdate(true);
            Configuration[] configurations = this._configurationAdmin.listConfigurations(sb.toString());
            if (configurations == null) {
                return;
            }
            for (Configuration configuration : configurations) {
                if (type == 2) {
                    configuration.delete();
                    continue;
                }
                if (dictionary == null) {
                    configuration.update();
                    continue;
                }
                configuration.update(dictionary);
            }
        }
        finally {
            ConfigurationThreadLocal.setLocalUpdate(false);
        }
    }

    @Reference(unbind="-")
    protected void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this._configurationAdmin = configurationAdmin;
    }

    @Reference(target="(destination.name=liferay/configuration)", unbind="-")
    protected void setDestination(Destination destination) {
    }
}

