/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.configuration.cluster.internal;

import com.liferay.portal.configuration.cluster.internal.ConfigurationThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.SynchronousConfigurationListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SynchronousConfigurationListener.class})
public class ConfigurationSynchronousConfigurationListener
implements SynchronousConfigurationListener {
    private ClusterLink _clusterLink;

    public void configurationEvent(ConfigurationEvent configurationEvent) {
        if (ConfigurationThreadLocal.isLocalUpdate()) {
            return;
        }
        Message message = new Message();
        message.setDestinationName("liferay/configuration");
        message.put("service.pid", (Object)configurationEvent.getPid());
        message.put("configuration.event.type", (Object)configurationEvent.getType());
        this._clusterLink.sendMulticastMessage(message, Priority.LEVEL10);
    }

    @Reference(unbind="-")
    protected void setClusterLink(ClusterLink clusterLink) {
        this._clusterLink = clusterLink;
    }

    @Reference(target="(destination.name=liferay/configuration)", unbind="-")
    protected void setDestination(Destination destination) {
    }
}

