/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cluster.multiple.internal.jgroups;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cluster.multiple.configuration.ClusterExecutorConfiguration;
import com.liferay.portal.cluster.multiple.internal.BaseClusterChannel;
import com.liferay.portal.cluster.multiple.internal.ClusterReceiver;
import com.liferay.portal.cluster.multiple.internal.io.ClusterSerializationUtil;
import com.liferay.portal.cluster.multiple.internal.jgroups.AddressImpl;
import com.liferay.portal.cluster.multiple.internal.jgroups.JGroupsReceiver;
import com.liferay.portal.kernel.cluster.Address;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.jgroups.JChannel;
import org.jgroups.Receiver;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;

public class JGroupsClusterChannel
extends BaseClusterChannel {
    private static final Log _log = LogFactoryUtil.getLog(JGroupsClusterChannel.class);
    private static final Method _getPropsMethod;
    private final String _clusterName;
    private final ClusterReceiver _clusterReceiver;
    private final JChannel _jChannel;
    private final Address _localAddress;

    public JGroupsClusterChannel(ExecutorService executorService, String channelLogicName, ProtocolStackConfigurator protocolStackConfigurator, String clusterName, ClusterReceiver clusterReceiver, InetAddress bindInetAddress, ClusterExecutorConfiguration clusterExecutorConfiguration, Map<ClassLoader, ClassLoader> classLoaders) {
        super(executorService);
        if (protocolStackConfigurator == null) {
            throw new NullPointerException("ProtocolStackConfigurator is null");
        }
        if (Validator.isNull((String)clusterName)) {
            throw new NullPointerException("Cluster name is null");
        }
        if (clusterReceiver == null) {
            throw new NullPointerException("Cluster receiver is null");
        }
        this._clusterName = clusterName;
        this._clusterReceiver = clusterReceiver;
        try {
            this._jChannel = new JChannel(protocolStackConfigurator);
            if (Validator.isNotNull((String)channelLogicName)) {
                this._jChannel.setName(channelLogicName);
            }
            if (bindInetAddress != null) {
                ProtocolStack protocolStack = this._jChannel.getProtocolStack();
                TP tp = protocolStack.getTransport();
                tp.setBindAddress(bindInetAddress);
            }
            this._jChannel.setReceiver((Receiver)new JGroupsReceiver(clusterReceiver, classLoaders));
            this._jChannel.connect(this._clusterName);
            this._localAddress = new AddressImpl(this._jChannel.getAddress());
            if (_log.isInfoEnabled()) {
                StringBundler sb = new StringBundler(7);
                sb.append("Create a new JGroups channel {channelName: ");
                sb.append(this._clusterName);
                sb.append(", localAddress: ");
                sb.append(this._localAddress.getDescription());
                sb.append(", properties: ");
                sb.append(this._getJChannelProperties(clusterExecutorConfiguration.excludedPropertyKeys()));
                sb.append("}");
                _log.info((Object)sb.toString());
            }
        }
        catch (Exception e) {
            throw new SystemException("Unable to initial cluster channel " + clusterName, (Throwable)e);
        }
    }

    @Override
    public void close() {
        this._jChannel.setReceiver(null);
        this._jChannel.close();
    }

    @Override
    public InetAddress getBindInetAddress() {
        ProtocolStack protocolStack = this._jChannel.getProtocolStack();
        Protocol protocol = protocolStack.getBottomProtocol();
        if (!(protocol instanceof TP)) {
            throw new IllegalStateException("Bottom protocol of jgroups is not a transport protocol");
        }
        TP transportProtocol = (TP)protocol;
        return (InetAddress)transportProtocol.getValue("bind_addr");
    }

    @Override
    public String getClusterName() {
        return this._clusterName;
    }

    @Override
    public ClusterReceiver getClusterReceiver() {
        return this._clusterReceiver;
    }

    @Override
    public Address getLocalAddress() {
        return this._localAddress;
    }

    @Override
    protected void doSendMessage(Serializable message, Address address) {
        if (this._jChannel.isClosed()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Cluster channel " + this._clusterName + " is alreay closed"));
            }
            return;
        }
        org.jgroups.Address jgroupsAddress = null;
        if (address != null) {
            jgroupsAddress = (org.jgroups.Address)address.getRealAddress();
        }
        try {
            this._jChannel.send(jgroupsAddress, ClusterSerializationUtil.writeObject(message));
            if (_log.isDebugEnabled()) {
                if (address == null) {
                    _log.debug((Object)("Send multicast message " + message));
                } else {
                    _log.debug((Object)("Send unicast message " + message));
                }
            }
        }
        catch (Exception e) {
            if (address == null) {
                throw new SystemException("Unable to send multicast message", (Throwable)e);
            }
            throw new SystemException("Unable to send unicast message", (Throwable)e);
        }
    }

    private String _getJChannelProperties(String[] excludedPropertyKeys) throws ReflectiveOperationException {
        StringBundler sb = new StringBundler();
        ProtocolStack protocolStack = this._jChannel.getProtocolStack();
        List protocols = protocolStack.getProtocols();
        for (int i = protocols.size() - 1; i >= 0; --i) {
            Protocol protocol = (Protocol)protocols.get(i);
            sb.append(protocol.getName());
            Map properties = (Map)_getPropsMethod.invoke(null, protocol);
            for (String excludedPropertyKey : excludedPropertyKeys) {
                properties.remove(excludedPropertyKey);
            }
            if (!properties.isEmpty()) {
                sb.append("(");
                for (Map.Entry entry : properties.entrySet()) {
                    sb.append((String)entry.getKey());
                    sb.append("=");
                    sb.append((String)entry.getValue());
                    sb.append(";");
                }
                sb.setStringAt(")", sb.index() - 1);
            }
            sb.append(":");
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    static {
        try {
            _getPropsMethod = ReflectionUtil.getDeclaredMethod(ProtocolStack.class, (String)"getProps", (Class[])new Class[]{Protocol.class});
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

