/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.catapult.internal;

import com.liferay.oauth.client.LocalOAuthClient;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.catapult.PortalCatapult;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Http;
import java.io.IOException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalCatapult.class})
public class PortalCatapultImpl
implements PortalCatapult {
    @Reference
    private Http _http;
    @Reference
    private LocalOAuthClient _localOAuthClient;
    @Reference
    private OAuth2ApplicationLocalService _oAuth2ApplicationLocalService;

    public byte[] launch(long companyId, String oAuth2ApplicationExternalReferenceCode, JSONObject payloadJSONObject, String resourcePath, long userId) throws PortalException {
        Http.Options options = new Http.Options();
        options.addHeader("Content-Type", "application/json");
        options.setBody(payloadJSONObject.toString(), "application/json", "UTF-8");
        OAuth2Application oAuth2Application = this._oAuth2ApplicationLocalService.getOAuth2ApplicationByExternalReferenceCode(oAuth2ApplicationExternalReferenceCode, companyId);
        options.setLocation(this._getLocation(oAuth2Application, resourcePath));
        options.setMethod(Http.Method.POST);
        this._localOAuthClient.consumeAccessToken(accessToken -> options.addHeader("Authorization", "Bearer " + accessToken), oAuth2Application, userId);
        try {
            return this._http.URLtoByteArray(options);
        }
        catch (IOException ioException) {
            return (byte[])ReflectionUtil.throwException((Throwable)ioException);
        }
    }

    private String _getLocation(OAuth2Application oAuth2Application, String resourcePath) {
        if (resourcePath.contains("://")) {
            return resourcePath;
        }
        String homePageURL = oAuth2Application.getHomePageURL();
        if (homePageURL.endsWith("/")) {
            homePageURL = homePageURL.substring(0, homePageURL.length() - 1);
        }
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        return StringBundler.concat((String[])new String[]{homePageURL, "/", resourcePath});
    }
}

