/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.test.util;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.junit.Assert;

public class TestPortalCacheListener<K extends Serializable, V>
implements PortalCacheListener<K, V> {
    private final List<Action> _actions = new CopyOnWriteArrayList<Action>();

    public void assertActionsCount(int count) {
        Assert.assertEquals((String)this._allActions(), (long)count, (long)this._actions.size());
    }

    public void assertEvicted(K key, V value, int timeToLive) {
        this._assertAction(ActionType.EVICT, key, value, timeToLive);
    }

    public void assertExpired(K key, V value, int timeToLive) {
        this._assertAction(ActionType.EXPIRE, key, value, timeToLive);
    }

    public void assertPut(K key, V value) {
        this._assertAction(ActionType.PUT, key, value, 0);
    }

    public void assertPut(K key, V value, int timeToLive) {
        this._assertAction(ActionType.PUT, key, value, timeToLive);
    }

    public void assertRemoveAll() {
        this._assertAction(ActionType.REMOVE_ALL, null, null, 0);
    }

    public void assertRemoved(K key, V value) {
        this._assertAction(ActionType.REMOVE, key, value, 0);
    }

    public void assertRemoved(K key, V value, int timeToLive) {
        this._assertAction(ActionType.REMOVE, key, value, timeToLive);
    }

    public void assertUpdated(K key, V value) {
        this._assertAction(ActionType.UPDATE, key, value, 0);
    }

    public void assertUpdated(K key, V value, int timeToLive) {
        this._assertAction(ActionType.UPDATE, key, value, timeToLive);
    }

    public void dispose() {
    }

    public void notifyEntryEvicted(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        this._actions.add(new Action(ActionType.EVICT, key, value, timeToLive));
    }

    public void notifyEntryExpired(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        this._actions.add(new Action(ActionType.EXPIRE, key, value, timeToLive));
    }

    public void notifyEntryPut(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        this._actions.add(new Action(ActionType.PUT, key, value, timeToLive));
    }

    public void notifyEntryRemoved(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        this._actions.add(new Action(ActionType.REMOVE, key, value, timeToLive));
    }

    public void notifyEntryUpdated(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        this._actions.add(new Action(ActionType.UPDATE, key, value, timeToLive));
    }

    public void notifyRemoveAll(PortalCache<K, V> portalCache) throws PortalCacheException {
        this._actions.add(new Action(ActionType.REMOVE_ALL, null, null, 0));
    }

    public void reset() {
        this._actions.clear();
    }

    private String _allActions() {
        StringBundler sb = new StringBundler(2 + 2 * this._actions.size());
        sb.append("All actions{");
        for (Action action : this._actions) {
            sb.append(action.toString());
            sb.append(",");
        }
        sb.setStringAt("}", sb.index() - 1);
        return sb.toString();
    }

    private void _assertAction(ActionType actionType, K key, V value, int timeToLive) {
        Action action = new Action(actionType, key, value, timeToLive);
        Assert.assertTrue((String)this._allActions(), (boolean)this._actions.contains(action));
    }

    private static enum ActionType {
        EVICT,
        EXPIRE,
        PUT,
        REMOVE,
        REMOVE_ALL,
        UPDATE;

    }

    private static class Action {
        private static final Object _NULL_OBJECT = new Object();
        private final ActionType _actionType;
        private final Object _key;
        private int _timeToLive;
        private final Object _value;

        public Action(ActionType actionType, Object key, Object value, int timeToLive) {
            this._actionType = actionType;
            if (key == null) {
                key = _NULL_OBJECT;
            }
            if (value == null) {
                value = _NULL_OBJECT;
            }
            this._key = key;
            this._value = value;
            this._timeToLive = timeToLive;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Action)) {
                return false;
            }
            Action action = (Action)object;
            return this._actionType.equals((Object)action._actionType) && this._key.equals(action._key) && this._value.equals(action._value) && this._timeToLive == action._timeToLive;
        }

        public ActionType getActionType() {
            return this._actionType;
        }

        public Object getKey() {
            return this._key;
        }

        public int getTimeToLive() {
            return this._timeToLive;
        }

        public Object getValue() {
            return this._value;
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (Object)((Object)this._actionType));
            hash = HashUtil.hash((int)hash, (Object)this._key);
            hash = HashUtil.hash((int)hash, (Object)this._value);
            return HashUtil.hash((int)hash, (int)this._timeToLive);
        }

        public String toString() {
            return StringBundler.concat((Object[])new Object[]{"{actiontype: ", this._actionType, ", key: ", this._key, ", timetolive: ", this._timeToLive, ", value: ", this._value, "}"});
        }
    }
}

