/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.test.util;

import com.liferay.portal.cache.BasePortalCache;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TestPortalCache<K extends Serializable, V>
extends BasePortalCache<K, V> {
    private final ConcurrentMap<K, V> _concurrentMap;
    private final String _portalCacheName;

    public TestPortalCache(PortalCacheManager<K, V> portalCacheManager, String portalCacheName) {
        super(portalCacheManager);
        this._portalCacheName = portalCacheName;
        this._concurrentMap = new ConcurrentHashMap();
    }

    public TestPortalCache(String portalCacheName) {
        super(null);
        this._portalCacheName = portalCacheName;
        this._concurrentMap = new ConcurrentHashMap();
    }

    public List<K> getKeys() {
        ArrayList<Serializable> keys = new ArrayList<Serializable>();
        for (Serializable key : this._concurrentMap.keySet()) {
            keys.add(key);
        }
        return keys;
    }

    public String getPortalCacheName() {
        return this._portalCacheName;
    }

    public void removeAll() {
        this._concurrentMap.clear();
        this.aggregatedPortalCacheListener.notifyRemoveAll((PortalCache)this);
    }

    protected V doGet(K key) {
        return this._concurrentMap.get(key);
    }

    protected void doPut(K key, V value, int timeToLive) {
        V oldValue = this._concurrentMap.put(key, value);
        if (oldValue != null) {
            this.aggregatedPortalCacheListener.notifyEntryUpdated((PortalCache)this, key, value, timeToLive);
        } else {
            this.aggregatedPortalCacheListener.notifyEntryPut((PortalCache)this, key, value, timeToLive);
        }
    }

    protected V doPutIfAbsent(K key, V value, int timeToLive) {
        V oldValue = this._concurrentMap.putIfAbsent(key, value);
        if (oldValue == null) {
            this.aggregatedPortalCacheListener.notifyEntryPut((PortalCache)this, key, value, timeToLive);
        }
        return oldValue;
    }

    protected void doRemove(K key) {
        Object value = this._concurrentMap.remove(key);
        this.aggregatedPortalCacheListener.notifyEntryRemoved((PortalCache)this, key, value, 0);
    }

    protected boolean doRemove(K key, V value) {
        boolean removed = this._concurrentMap.remove(key, value);
        this.aggregatedPortalCacheListener.notifyEntryRemoved((PortalCache)this, key, value, 0);
        return removed;
    }

    protected V doReplace(K key, V value, int timeToLive) {
        V oldValue = this._concurrentMap.replace(key, value);
        if (oldValue != null) {
            this.aggregatedPortalCacheListener.notifyEntryUpdated((PortalCache)this, key, value, timeToLive);
        }
        return oldValue;
    }

    protected boolean doReplace(K key, V oldValue, V newValue, int timeToLive) {
        boolean replaced = this._concurrentMap.replace(key, oldValue, newValue);
        if (replaced) {
            this.aggregatedPortalCacheListener.notifyEntryUpdated((PortalCache)this, key, newValue, timeToLive);
        }
        return replaced;
    }
}

