/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.multiple.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.cache.multiple.internal.PortalCacheClusterEventType;
import java.io.Serializable;

public class PortalCacheClusterEvent {
    private long _companyId = Long.MIN_VALUE;
    private final Serializable _elementKey;
    private Serializable _elementValue;
    private final PortalCacheClusterEventType _portalCacheClusterEventType;
    private final String _portalCacheManagerName;
    private final String _portalCacheName;
    private int _timeToLive = 0;

    public PortalCacheClusterEvent(String portalCacheManagerName, String portalCacheName, Serializable elementKey, PortalCacheClusterEventType portalCacheClusterEventType) {
        if (portalCacheManagerName == null) {
            throw new NullPointerException("Portal cache manager name is null");
        }
        if (portalCacheName == null) {
            throw new NullPointerException("Portal cache name is null");
        }
        if (portalCacheClusterEventType == null) {
            throw new NullPointerException("Portal cache cluster event type is null");
        }
        if (elementKey == null && !portalCacheClusterEventType.equals((Object)PortalCacheClusterEventType.REMOVE_ALL)) {
            throw new NullPointerException("Element key is null");
        }
        this._portalCacheManagerName = portalCacheManagerName;
        this._portalCacheName = portalCacheName;
        this._elementKey = elementKey;
        this._portalCacheClusterEventType = portalCacheClusterEventType;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public Serializable getElementKey() {
        return this._elementKey;
    }

    public Serializable getElementValue() {
        return this._elementValue;
    }

    public PortalCacheClusterEventType getEventType() {
        return this._portalCacheClusterEventType;
    }

    public String getPortalCacheManagerName() {
        return this._portalCacheManagerName;
    }

    public String getPortalCacheName() {
        return this._portalCacheName;
    }

    public int getTimeToLive() {
        return this._timeToLive;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setElementValue(Serializable elementValue) {
        this._elementValue = elementValue;
    }

    public void setTimeToLive(int timeToLive) {
        if (timeToLive < 0) {
            throw new IllegalArgumentException("Time to live is negative");
        }
        this._timeToLive = timeToLive;
    }

    public String toString() {
        StringBundler sb = new StringBundler(15);
        sb.append("{companyId=");
        sb.append(this._companyId);
        sb.append(", elementKey=");
        sb.append((Object)this._elementKey);
        if (this._elementValue != null) {
            sb.append(", elementValue=");
            sb.append((Object)this._elementValue);
        }
        sb.append(", timeToLive=");
        sb.append(this._timeToLive);
        sb.append(", portalCacheClusterEventType=");
        sb.append((Object)this._portalCacheClusterEventType);
        sb.append(", portalCacheManagerName=");
        sb.append(this._portalCacheManagerName);
        sb.append(", portalCacheName=");
        sb.append(this._portalCacheName);
        sb.append("}");
        return sb.toString();
    }
}

