/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.multiple.internal;

import com.liferay.portal.cache.PortalCacheReplicator;
import com.liferay.portal.cache.multiple.internal.PortalCacheClusterEvent;
import com.liferay.portal.cache.multiple.internal.PortalCacheClusterEventType;
import com.liferay.portal.cache.multiple.internal.cluster.link.PortalCacheClusterLink;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.util.GetterUtil;
import java.io.Serializable;
import java.util.Properties;

public class ClusterLinkPortalCacheReplicator<K extends Serializable, V extends Serializable>
implements PortalCacheReplicator<K, V> {
    private final PortalCacheClusterLink _portalCacheClusterLink;
    private final boolean _replicatePuts;
    private final boolean _replicatePutsViaCopy;
    private final boolean _replicateRemovals;
    private final boolean _replicateUpdates;
    private final boolean _replicateUpdatesViaCopy;

    public ClusterLinkPortalCacheReplicator(Properties properties, PortalCacheClusterLink portalCacheClusterLink) {
        this._portalCacheClusterLink = portalCacheClusterLink;
        this._replicatePuts = GetterUtil.getBoolean((String)properties.getProperty("replicatePuts"), (boolean)true);
        this._replicatePutsViaCopy = GetterUtil.getBoolean((String)properties.getProperty("replicatePutsViaCopy"), (boolean)false);
        this._replicateRemovals = GetterUtil.getBoolean((String)properties.getProperty("replicateRemovals"), (boolean)true);
        this._replicateUpdates = GetterUtil.getBoolean((String)properties.getProperty("replicateUpdates"), (boolean)true);
        this._replicateUpdatesViaCopy = GetterUtil.getBoolean((String)properties.getProperty("replicateUpdatesViaCopy"), (boolean)false);
    }

    public void dispose() {
    }

    public void notifyEntryEvicted(PortalCache<K, V> portalCache, K key, V value, int timeToLive) {
    }

    public void notifyEntryExpired(PortalCache<K, V> portalCache, K key, V value, int timeToLive) {
    }

    public void notifyEntryPut(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        if (!this._replicatePuts) {
            return;
        }
        PortalCacheManager portalCacheManager = portalCache.getPortalCacheManager();
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(portalCacheManager.getPortalCacheManagerName(), portalCache.getPortalCacheName(), (Serializable)key, PortalCacheClusterEventType.PUT);
        if (this._replicatePutsViaCopy) {
            portalCacheClusterEvent.setElementValue((Serializable)value);
            portalCacheClusterEvent.setTimeToLive(timeToLive);
        }
        this._portalCacheClusterLink.sendEvent(portalCacheClusterEvent);
    }

    public void notifyEntryRemoved(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        if (!this._replicateRemovals) {
            return;
        }
        PortalCacheManager portalCacheManager = portalCache.getPortalCacheManager();
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(portalCacheManager.getPortalCacheManagerName(), portalCache.getPortalCacheName(), (Serializable)key, PortalCacheClusterEventType.REMOVE);
        this._portalCacheClusterLink.sendEvent(portalCacheClusterEvent);
    }

    public void notifyEntryUpdated(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
        if (!this._replicateUpdates) {
            return;
        }
        PortalCacheManager portalCacheManager = portalCache.getPortalCacheManager();
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(portalCacheManager.getPortalCacheManagerName(), portalCache.getPortalCacheName(), (Serializable)key, PortalCacheClusterEventType.UPDATE);
        if (this._replicateUpdatesViaCopy) {
            portalCacheClusterEvent.setElementValue((Serializable)value);
            portalCacheClusterEvent.setTimeToLive(timeToLive);
        }
        this._portalCacheClusterLink.sendEvent(portalCacheClusterEvent);
    }

    public void notifyRemoveAll(PortalCache<K, V> portalCache) throws PortalCacheException {
        if (!this._replicateRemovals) {
            return;
        }
        PortalCacheManager portalCacheManager = portalCache.getPortalCacheManager();
        PortalCacheClusterEvent portalCacheClusterEvent = new PortalCacheClusterEvent(portalCacheManager.getPortalCacheManagerName(), portalCache.getPortalCacheName(), null, PortalCacheClusterEventType.REMOVE_ALL);
        this._portalCacheClusterLink.sendEvent(portalCacheClusterEvent);
    }
}

