/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.multiple.internal.cluster.link;

import com.liferay.portal.cache.multiple.configuration.PortalCacheClusterConfiguration;
import com.liferay.portal.cache.multiple.internal.PortalCacheClusterEvent;
import com.liferay.portal.cache.multiple.internal.cluster.link.PortalCacheClusterChannel;
import com.liferay.portal.cache.multiple.internal.cluster.link.PortalCacheClusterChannelFactory;
import com.liferay.portal.cache.multiple.internal.cluster.link.PortalCacheClusterChannelSelector;
import com.liferay.portal.cache.multiple.internal.cluster.link.UniformPortalCacheClusterChannelSelector;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cluster.Priority;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(configurationPid={"com.liferay.portal.cache.cluster.configuration.PortalCacheClusterConfiguration"}, enabled=false, immediate=true, service={PortalCacheClusterLink.class})
public class PortalCacheClusterLink {
    @Reference
    private PortalCacheClusterChannelFactory _portalCacheClusterChannelFactory;
    private volatile List<PortalCacheClusterChannel> _portalCacheClusterChannels;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private volatile PortalCacheClusterChannelSelector _portalCacheClusterChannelSelector;

    public long getSubmittedEventNumber() {
        return this._portalCacheClusterChannelSelector.getSelectedNumber();
    }

    public void sendEvent(PortalCacheClusterEvent portalCacheClusterEvent) {
        PortalCacheClusterChannel portalCacheClusterChannel = this._portalCacheClusterChannelSelector.select(this._portalCacheClusterChannels, portalCacheClusterEvent);
        portalCacheClusterChannel.sendEvent(portalCacheClusterEvent);
    }

    @Activate
    @Modified
    protected void activate(ComponentContext componentContext) {
        PortalCacheClusterConfiguration portalCacheClusterConfiguration = (PortalCacheClusterConfiguration)ConfigurableUtil.createConfigurable(PortalCacheClusterConfiguration.class, (Dictionary)componentContext.getProperties());
        Priority[] priorities = portalCacheClusterConfiguration.priorities();
        this._portalCacheClusterChannels = new ArrayList<PortalCacheClusterChannel>(priorities.length);
        for (Priority priority : priorities) {
            PortalCacheClusterChannel portalCacheClusterChannel = this._portalCacheClusterChannelFactory.createPortalCacheClusterChannel(priority);
            this._portalCacheClusterChannels.add(portalCacheClusterChannel);
        }
        if (this._portalCacheClusterChannelSelector == null) {
            this._portalCacheClusterChannelSelector = new UniformPortalCacheClusterChannelSelector();
        }
    }

    @Deactivate
    protected void deactivate() {
        for (PortalCacheClusterChannel portalCacheClusterChannel : this._portalCacheClusterChannels) {
            portalCacheClusterChannel.destroy();
        }
        this._portalCacheClusterChannels.clear();
        this._portalCacheClusterChannels = null;
    }
}

