/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.multiple.internal.cluster.link;

import com.liferay.portal.cache.multiple.internal.PortalCacheClusterEvent;
import com.liferay.portal.cache.multiple.internal.cluster.link.PortalCacheClusterChannel;
import com.liferay.portal.cache.multiple.internal.cluster.link.PortalCacheClusterEventQueue;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.Priority;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.util.SerializableUtil;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ClusterLinkPortalCacheClusterChannel
implements PortalCacheClusterChannel,
Runnable {
    private static final Log _log = LogFactoryUtil.getLog(ClusterLinkPortalCacheClusterChannel.class);
    private static final AtomicInteger _dispatchThreadCounter = new AtomicInteger(0);
    private final ClusterLink _clusterLink;
    private final String _destinationName;
    private volatile boolean _destroy;
    private final Thread _dispatchThread;
    private final PortalCacheClusterEventQueue _portalCacheClusterEventQueue;
    private final Priority _priority;
    private final AtomicLong _sentEventCounter = new AtomicLong(0L);
    private volatile boolean _started;

    public ClusterLinkPortalCacheClusterChannel(ClusterLink clusterLink, String destinationName, PortalCacheClusterEventQueue portalCacheClusterEventQueue, Priority priority) {
        this._clusterLink = clusterLink;
        this._destinationName = destinationName;
        this._portalCacheClusterEventQueue = portalCacheClusterEventQueue;
        this._priority = priority;
        this._dispatchThread = new Thread((Runnable)this, "PortalCacheClusterChannel dispatch thread-" + _dispatchThreadCounter.getAndIncrement());
    }

    @Override
    public void destroy() {
        this._destroy = true;
        this._dispatchThread.interrupt();
    }

    public void dispatchEvent(PortalCacheClusterEvent portalCacheClusterEvent) {
        Message message = new Message();
        message.setDestinationName(this._destinationName);
        message.setPayload((Object)SerializableUtil.serialize(portalCacheClusterEvent));
        this._clusterLink.sendMulticastMessage(message, this._priority);
    }

    @Override
    public long getCoalescedEventNumber() {
        return this._portalCacheClusterEventQueue.coalescedCount();
    }

    @Override
    public int getPendingEventNumber() {
        return this._portalCacheClusterEventQueue.pendingCount();
    }

    @Override
    public long getSentEventNumber() {
        return this._sentEventCounter.get();
    }

    @Override
    public void run() {
        block4: while (true) {
            try {
                while (true) {
                    if (this._destroy) {
                        for (PortalCacheClusterEvent event : this._portalCacheClusterEventQueue.takeSnapshot()) {
                            this.dispatchEvent(event);
                            this._sentEventCounter.incrementAndGet();
                        }
                        break block4;
                    }
                    try {
                        PortalCacheClusterEvent portalCacheClusterEvent = this._portalCacheClusterEventQueue.take();
                        this.dispatchEvent(portalCacheClusterEvent);
                        this._sentEventCounter.incrementAndGet();
                        continue block4;
                    }
                    catch (InterruptedException portalCacheClusterEvent) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)"Please fix the unexpected throwable", t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendEvent(PortalCacheClusterEvent portalCacheClusterEvent) {
        if (!this._started) {
            ClusterLinkPortalCacheClusterChannel clusterLinkPortalCacheClusterChannel = this;
            synchronized (clusterLinkPortalCacheClusterChannel) {
                if (!this._started) {
                    this._dispatchThread.start();
                    this._started = true;
                }
            }
        }
        if (this._destroy) {
            this.dispatchEvent(portalCacheClusterEvent);
        } else {
            try {
                this._portalCacheClusterEventQueue.put(portalCacheClusterEvent);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

