/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.multiple.internal.bootstrap;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerProvider;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.AnnotatedObjectInputStream;
import com.liferay.portal.kernel.io.AnnotatedObjectOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SocketUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={})
public class ClusterLinkBootstrapLoaderHelperUtil {
    private static final String _COMMAND_SOCKET_CLOSE = "${SOCKET_CLOSE}";
    private static final Log _log = LogFactoryUtil.getLog(ClusterLinkBootstrapLoaderHelperUtil.class);
    private static final MethodKey _createServerSocketFromClusterMethodKey = new MethodKey(ClusterLinkBootstrapLoaderHelperUtil.class, "createServerSocketFromCluster", new Class[]{String.class, List.class});
    private static final Map<String, List<String>> _deferredPortalCaches = new HashMap<String, List<String>>();
    private static final SocketUtil.ServerSocketConfigurator _serverSocketConfigurator = new SocketCacheServerSocketConfiguration();
    private static final ThreadLocal<Boolean> _skipBootstrapLoaderThreadLocal = new CentralizedThreadLocal(ClusterLinkBootstrapLoaderHelperUtil.class + "._skipBootstrapLoaderThreadLocal", () -> Boolean.FALSE, false);
    private static boolean _started;

    public static SocketAddress createServerSocketFromCluster(String portalCacheManagerName, List<String> portalCacheNames) throws Exception {
        ClusterNode localClusterNode = ClusterExecutorUtil.getLocalClusterNode();
        ServerSocketChannel serverSocketChannel = SocketUtil.createServerSocketChannel((InetAddress)localClusterNode.getBindInetAddress(), (int)GetterUtil.getInteger((String)PropsUtil.get((String)"ehcache.socket.start.port"), (int)32454), (SocketUtil.ServerSocketConfigurator)_serverSocketConfigurator);
        ServerSocket serverSocket = serverSocketChannel.socket();
        ClusterLinkBootstrapLoaderServerThread clusterLinkBootstrapLoaderServerThread = new ClusterLinkBootstrapLoaderServerThread(serverSocket, portalCacheManagerName, portalCacheNames);
        clusterLinkBootstrapLoaderServerThread.start();
        return serverSocket.getLocalSocketAddress();
    }

    public static boolean isSkipped() {
        return _skipBootstrapLoaderThreadLocal.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void loadCachesFromCluster(String portalCacheManagerName, String ... portalCacheNames) throws Exception {
        var2_2 = ClusterLinkBootstrapLoaderHelperUtil.class;
        synchronized (ClusterLinkBootstrapLoaderHelperUtil.class) {
            block32: {
                if (!ClusterLinkBootstrapLoaderHelperUtil._started) {
                    portalCaches = ClusterLinkBootstrapLoaderHelperUtil._deferredPortalCaches.get(portalCacheManagerName);
                    if (portalCaches == null) {
                        portalCaches = new ArrayList<String>();
                        ClusterLinkBootstrapLoaderHelperUtil._deferredPortalCaches.put(portalCacheManagerName, portalCaches);
                    }
                    Collections.addAll(portalCaches, portalCacheNames);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                clusterNodes = ClusterExecutorUtil.getClusterNodes();
                if (ClusterLinkBootstrapLoaderHelperUtil._log.isInfoEnabled()) {
                    ClusterLinkBootstrapLoaderHelperUtil._log.info((Object)("Cluster nodes " + clusterNodes));
                }
                if (clusterNodes.size() <= 1) {
                    if (ClusterLinkBootstrapLoaderHelperUtil._log.isDebugEnabled()) {
                        ClusterLinkBootstrapLoaderHelperUtil._log.debug((Object)"Not loading cache from cluster because a cluster peer was not found");
                    }
                    return;
                }
                portalCacheManager = PortalCacheManagerProvider.getPortalCacheManager((String)portalCacheManagerName);
                if (!portalCacheManager.isClusterAware()) {
                    return;
                }
                clusterRequest = ClusterRequest.createMulticastRequest((Serializable)new MethodHandler(ClusterLinkBootstrapLoaderHelperUtil._createServerSocketFromClusterMethodKey, new Object[]{portalCacheManagerName, Arrays.asList(portalCacheNames)}), (boolean)true);
                futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
                clusterNodeResponses = futureClusterResponses.getPartialResults();
                clusterNodeResponse = null;
                try {
                    clusterNodeResponse = (ClusterNodeResponse)clusterNodeResponses.poll(GetterUtil.getLong((String)PropsUtil.get((String)"cluster.link.node.bootup.response.timeout"), (long)10000L), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                    return;
                }
                if (clusterNodeResponse == null) {
                    if (ClusterLinkBootstrapLoaderHelperUtil._log.isWarnEnabled()) {
                        ClusterLinkBootstrapLoaderHelperUtil._log.warn((Object)"Unable to load cache from the cluster because there was no peer response");
                    }
                    return;
                }
                if (ClusterLinkBootstrapLoaderHelperUtil._log.isInfoEnabled()) {
                    ClusterLinkBootstrapLoaderHelperUtil._log.info((Object)("Load cache data from cluster node " + clusterNodeResponse.getClusterNode()));
                }
                socket = null;
                try {
                    remoteSocketAddress = (SocketAddress)clusterNodeResponse.getResult();
                    if (remoteSocketAddress == null) {
                        ClusterLinkBootstrapLoaderHelperUtil._log.error((Object)("Cluster peer " + clusterNodeResponse.getClusterNode() + " responded with a null socket address"));
                        return;
                    }
                    socket = new Socket();
                    socket.connect(remoteSocketAddress);
                    socket.shutdownOutput();
                    objectInputStream = new AnnotatedObjectInputStream(socket.getInputStream());
                    portalCache = null;
                    try {
                        while (true) lbl-1000:
                        // 4 sources

                        {
                            if ((object = objectInputStream.readObject()) instanceof CacheElement) {
                                cacheElement = (CacheElement)object;
                                PortalCacheHelperUtil.putWithoutReplicator(portalCache, (Serializable)cacheElement.getKey(), (Object)cacheElement.getValue());
                                continue;
                            }
                            if (!(object instanceof String)) ** break;
                            if ("${SOCKET_CLOSE}".equals(object)) {
                                break block32;
                            }
                            ClusterLinkBootstrapLoaderHelperUtil._skipBootstrapLoaderThreadLocal.set(Boolean.TRUE);
                            try {
                                portalCache = portalCacheManager.getPortalCache((String)object);
                            }
                            finally {
                                ClusterLinkBootstrapLoaderHelperUtil._skipBootstrapLoaderThreadLocal.remove();
                                continue;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
                        throw new SystemException("Socket input stream returned invalid object " + object);
                    }
                    finally {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                    }
                }
                catch (Exception e) {
                    throw new Exception("Unable to load cache data from cluster node " + clusterNodeResponse.getClusterNode(), e);
                }
                finally {
                    if (socket != null) {
                        socket.close();
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate() {
        if (!_started) {
            _started = true;
        }
        if (_deferredPortalCaches.isEmpty()) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Loading deferred caches");
        }
        try {
            for (Map.Entry<String, List<String>> entry : _deferredPortalCaches.entrySet()) {
                List<String> portalCacheNames = entry.getValue();
                if (portalCacheNames.isEmpty()) continue;
                ClusterLinkBootstrapLoaderHelperUtil.loadCachesFromCluster(entry.getKey(), portalCacheNames.toArray(new String[portalCacheNames.size()]));
            }
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to load cache data from the cluster", (Throwable)e);
            }
        }
        finally {
            _deferredPortalCaches.clear();
        }
    }

    private static class SocketCacheServerSocketConfiguration
    implements SocketUtil.ServerSocketConfigurator {
        private SocketCacheServerSocketConfiguration() {
        }

        public void configure(ServerSocket serverSocket) throws SocketException {
            serverSocket.setSoTimeout(GetterUtil.getInteger((String)PropsUtil.get((String)"ehcache.socket.so.timeout"), (int)10000));
        }
    }

    private static class ClusterLinkBootstrapLoaderServerThread
    extends Thread {
        private final String _portalCacheManagerName;
        private final List<String> _portalCacheNames;
        private final ServerSocket _serverSocket;

        public ClusterLinkBootstrapLoaderServerThread(ServerSocket serverSocket, String portalCacheManagerName, List<String> portalCacheNames) {
            this._serverSocket = serverSocket;
            this._portalCacheManagerName = portalCacheManagerName;
            this._portalCacheNames = portalCacheNames;
            this.setDaemon(true);
            this.setName(ClusterLinkBootstrapLoaderServerThread.class.getName() + " - " + portalCacheNames);
            this.setPriority(5);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Socket socket = null;
            try {
                try {
                    socket = this._serverSocket.accept();
                }
                catch (SocketTimeoutException ste) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Terminating the socket thread " + this.getName() + " that the client requested but never used"));
                    }
                    if (socket == null) return;
                    try {
                        socket.close();
                        return;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                socket.shutdownInput();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            OutputStream outputStream = socket.getOutputStream();
            Throwable throwable = null;
            try (AnnotatedObjectOutputStream objectOutputStream = new AnnotatedObjectOutputStream(outputStream);){
                PortalCacheManager portalCacheManager = PortalCacheManagerProvider.getPortalCacheManager((String)this._portalCacheManagerName);
                for (String portalCacheName : this._portalCacheNames) {
                    PortalCache portalCache = portalCacheManager.getPortalCache(portalCacheName);
                    if (portalCache == null) {
                        _skipBootstrapLoaderThreadLocal.set(Boolean.TRUE);
                        try {
                            portalCacheManager.getPortalCache(portalCacheName);
                            continue;
                        }
                        finally {
                            _skipBootstrapLoaderThreadLocal.remove();
                            continue;
                        }
                    }
                    objectOutputStream.writeObject(portalCacheName);
                    List keys = portalCache.getKeys();
                    for (Serializable key : keys) {
                        Serializable value = (Serializable)portalCache.get(key);
                        if (value == null) continue;
                        CacheElement cacheElement = new CacheElement(key, value);
                        objectOutputStream.writeObject(cacheElement);
                    }
                }
                objectOutputStream.writeObject(ClusterLinkBootstrapLoaderHelperUtil._COMMAND_SOCKET_CLOSE);
                return;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            }
        }
    }

    private static class CacheElement
    implements Serializable {
        private final Serializable _key;
        private final Serializable _value;

        public CacheElement(Serializable key, Serializable value) {
            this._key = key;
            this._value = value;
        }

        public Serializable getKey() {
            return this._key;
        }

        public Serializable getValue() {
            return this._value;
        }
    }
}

