/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.internal.dao.orm;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.cache.internal.dao.orm.CTAwarePortalCache;
import com.liferay.portal.cache.internal.dao.orm.EmptyResult;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LRUMap;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.servlet.filters.threadlocal.ThreadLocalFilterThreadLocal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={FinderCache.class})
public class FinderCacheImpl
implements FinderCache,
PortalCacheManagerListener {
    private static final String _GROUP_KEY_PREFIX = FinderCache.class.getName() + ".";
    private static final Log _log = LogFactoryUtil.getLog(FinderCacheImpl.class);
    private static final MethodKey _clearDSLQueryCacheMethodKey = new MethodKey(FinderCacheUtil.class, "clearDSLQueryCache", new Class[]{String.class});
    private final Map<String, ArgumentsResolverHolder> _argumentsResolverHolderMap = new ConcurrentHashMap<String, ArgumentsResolverHolder>();
    private volatile CacheKeyGenerator _baseModelCacheKeyGenerator;
    private BundleContext _bundleContext;
    private volatile CacheKeyGenerator _cacheKeyGenerator;
    @Reference
    private ClusterExecutor _clusterExecutor;
    private final Map<String, Set<String>> _dslQueryCacheNamesMap = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Map<String, FinderPath>> _finderPathsMap = new ConcurrentHashMap<String, Map<String, FinderPath>>();
    private ThreadLocal<LRUMap<LocalCacheKey, Serializable>> _localCache;
    @Reference
    private MultiVMPool _multiVMPool;
    private final ConcurrentMap<String, PortalCache<Serializable, Serializable>> _portalCaches = new ConcurrentHashMap<String, PortalCache<Serializable, Serializable>>();
    @Reference
    private Props _props;
    private ServiceRegistration<CacheRegistryItem> _serviceRegistration;
    private ServiceTrackerMap<String, ArgumentsResolverHolder> _serviceTrackerMap;
    private boolean _valueObjectFinderCacheEnabled;
    private int _valueObjectFinderCacheListThreshold;

    public void clearByEntityCache(String className) {
        this.clearLocalCache();
        this._clearCache(className);
        this._clearCache(this._getCacheNameWithPagination(className));
        this._clearCache(this._getCacheNameWithoutPagination(className));
        this._clearDSLQueryCache(className);
    }

    public void clearCache() {
        this.clearLocalCache();
        for (PortalCache portalCache : this._portalCaches.values()) {
            portalCache.removeAll();
        }
    }

    public void clearCache(Class<?> clazz) {
        this.clearByEntityCache(clazz.getName());
    }

    public void clearDSLQueryCache(String tableName) {
        this._clearDSLQueryCache(tableName);
        if (this._clusterExecutor.isEnabled() && ClusterInvokeThreadLocal.isEnabled()) {
            try {
                ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)new MethodHandler(_clearDSLQueryCacheMethodKey, new Object[]{tableName}), (boolean)true);
                clusterRequest.setFireAndForget(true);
                this._clusterExecutor.execute(clusterRequest);
            }
            catch (Throwable throwable) {
                _log.error((Object)throwable, throwable);
            }
        }
    }

    public void clearLocalCache() {
        if (this._localCache != null) {
            this._localCache.remove();
        }
    }

    public void dispose() {
        this._portalCaches.clear();
    }

    public Object getResult(FinderPath finderPath, Object[] args, BasePersistence<?> basePersistence) {
        PortalCache<Serializable, Serializable> portalCache;
        if (!this._valueObjectFinderCacheEnabled || !CacheRegistryUtil.isActive()) {
            return null;
        }
        Serializable cacheKey = this._encodeCacheKey(finderPath, args);
        Serializable cacheValue = null;
        Map localCache = null;
        LocalCacheKey localCacheKey = null;
        if (this._isLocalCacheEnabled()) {
            localCache = (Map)this._localCache.get();
            localCacheKey = new LocalCacheKey(finderPath.getCacheName(), cacheKey);
            cacheValue = (Serializable)localCache.get(localCacheKey);
        }
        if (cacheValue == null && (cacheValue = (Serializable)(portalCache = this._getPortalCache(finderPath.getCacheName())).get(cacheKey)) != null && localCache != null) {
            localCache.put(localCacheKey, cacheValue);
        }
        if (cacheValue == null) {
            return null;
        }
        if (cacheValue instanceof EmptyResult) {
            EmptyResult emptyResult = (EmptyResult)cacheValue;
            if (emptyResult.matches(args)) {
                return Collections.emptyList();
            }
            return null;
        }
        if (!finderPath.isBaseModelResult()) {
            return cacheValue;
        }
        if (cacheValue instanceof Serializable[]) {
            Object[] primaryKeys = (Serializable[])cacheValue;
            if (primaryKeys.length == 1) {
                BaseModel result = basePersistence.fetchByPrimaryKey((Serializable)primaryKeys[0]);
                if (result == null) {
                    return null;
                }
                return Arrays.asList(result);
            }
            Set primaryKeysSet = SetUtil.fromArray((Object[])primaryKeys);
            Map map = basePersistence.fetchByPrimaryKeys(primaryKeysSet);
            if (map.size() < primaryKeysSet.size()) {
                return null;
            }
            ArrayList list = new ArrayList(primaryKeys.length);
            for (Object curPrimaryKey : primaryKeys) {
                list.add(map.get(curPrimaryKey));
            }
            return Collections.unmodifiableList(list);
        }
        return basePersistence.fetchByPrimaryKey(cacheValue);
    }

    public void init() {
    }

    public void invalidate() {
        this.clearCache();
    }

    public void notifyPortalCacheAdded(String portalCacheName) {
    }

    public void notifyPortalCacheRemoved(String portalCacheName) {
        if (portalCacheName.startsWith(_GROUP_KEY_PREFIX)) {
            this._portalCaches.remove(portalCacheName.substring(_GROUP_KEY_PREFIX.length()));
        }
    }

    public void putResult(FinderPath finderPath, Object[] args, Object result) {
        String[] originalFinderPaths;
        if (!this._valueObjectFinderCacheEnabled || !CacheRegistryUtil.isActive() || result == null) {
            return;
        }
        Serializable[] cacheValue = (Serializable[])result;
        if (result instanceof BaseModel) {
            BaseModel model = (BaseModel)result;
            cacheValue = model.getPrimaryKeyObj();
        } else if (result instanceof List) {
            List objects = (List)result;
            if (objects.isEmpty()) {
                cacheValue = new EmptyResult(args);
            } else {
                if (objects.size() > this._valueObjectFinderCacheListThreshold && this._valueObjectFinderCacheListThreshold > 0) {
                    this._removeResult(finderPath, args);
                    return;
                }
                if (finderPath.isBaseModelResult()) {
                    Serializable[] primaryKeys = new Serializable[objects.size()];
                    for (int i = 0; i < objects.size(); ++i) {
                        BaseModel baseModel = (BaseModel)objects.get(i);
                        primaryKeys[i] = baseModel.getPrimaryKeyObj();
                    }
                    cacheValue = primaryKeys;
                }
            }
        }
        String cacheName = finderPath.getCacheName();
        String cacheKeyPrefix = finderPath.getCacheKeyPrefix();
        String[] finderPaths = this._finderPathsMap.get(cacheName);
        if (finderPaths == null && (originalFinderPaths = this._finderPathsMap.putIfAbsent(cacheName, (Map<String, FinderPath>)(finderPaths = new ConcurrentHashMap<String, FinderPath>()))) != null) {
            finderPaths = originalFinderPaths;
        }
        if (!finderPaths.containsKey(cacheKeyPrefix)) {
            if (cacheKeyPrefix.startsWith("dslQuery")) {
                for (String tableName : FinderPath.decodeDSLQueryCacheName((String)cacheName)) {
                    Set dslQueryCacheNames = this._dslQueryCacheNamesMap.computeIfAbsent(tableName, key -> Collections.newSetFromMap(new ConcurrentHashMap()));
                    dslQueryCacheNames.add(cacheName);
                }
            }
            finderPaths.putIfAbsent((String)cacheKeyPrefix, (FinderPath)finderPath);
        }
        Serializable cacheKey = this._encodeCacheKey(finderPath, args);
        if (this._isLocalCacheEnabled()) {
            Map localCache = (Map)this._localCache.get();
            localCache.put(new LocalCacheKey(finderPath.getCacheName(), cacheKey), cacheValue);
        }
        PortalCacheHelperUtil.putWithoutReplicator(this._getPortalCache(finderPath.getCacheName()), (Serializable)cacheKey, (Object)cacheValue);
    }

    public void removeByEntityCache(String className, BaseModel<?> baseModel) {
        ArgumentsResolverHolder argumentsResolverHolder = (ArgumentsResolverHolder)this._serviceTrackerMap.getService((Object)className);
        if (argumentsResolverHolder == null) {
            this.clearByEntityCache(className);
            return;
        }
        this.clearLocalCache();
        this._clearCache(this._getCacheNameWithPagination(className));
        this._clearCache(this._getCacheNameWithoutPagination(className));
        this._clearDSLQueryCache(className);
        ArgumentsResolver argumentsResolver = argumentsResolverHolder.getArgumentsResolver();
        for (FinderPath finderPath : this._getFinderPaths(className)) {
            this.removeResult(finderPath, argumentsResolver.getArguments(finderPath, baseModel, false, false));
            this.removeResult(finderPath, argumentsResolver.getArguments(finderPath, baseModel, true, true));
        }
    }

    public void removeCache(String className) {
        PortalCache portalCache = (PortalCache)this._portalCaches.remove(className);
        if (portalCache instanceof CTAwarePortalCache) {
            CTAwarePortalCache ctAwarePortalCache = (CTAwarePortalCache)portalCache;
            ctAwarePortalCache.destroy();
        } else {
            String groupKey = _GROUP_KEY_PREFIX.concat(className);
            this._multiVMPool.removePortalCache(groupKey);
        }
        this._finderPathsMap.remove(className);
    }

    public void removeCacheByEntityCache(String cacheName) {
        this.removeCache(cacheName);
        this.removeCache(this._getCacheNameWithPagination(cacheName));
        this.removeCache(this._getCacheNameWithoutPagination(cacheName));
        String tableName = null;
        ArgumentsResolverHolder argumentsResolverHolder = (ArgumentsResolverHolder)this._serviceTrackerMap.getService((Object)cacheName);
        tableName = argumentsResolverHolder == null ? cacheName : argumentsResolverHolder.getTableName();
        Set<String> dslQueryCacheNames = this._dslQueryCacheNamesMap.remove(tableName);
        if (dslQueryCacheNames != null) {
            for (String dslQueryCacheName : dslQueryCacheNames) {
                this.removeCache(dslQueryCacheName);
            }
        }
    }

    public void removeResult(FinderPath finderPath, Object[] args) {
        if (!this._valueObjectFinderCacheEnabled || !CacheRegistryUtil.isActive()) {
            return;
        }
        this._removeResult(finderPath, args);
    }

    public void updateByEntityCache(String className, BaseModel<?> baseModel) {
        if (!this._valueObjectFinderCacheEnabled) {
            return;
        }
        ArgumentsResolverHolder argumentsResolverHolder = (ArgumentsResolverHolder)this._serviceTrackerMap.getService((Object)className);
        if (argumentsResolverHolder == null) {
            this.clearByEntityCache(className);
            return;
        }
        this.clearLocalCache();
        this._clearCache(this._getCacheNameWithPagination(className));
        this._clearDSLQueryCache(className);
        HashSet<FinderPath> finderPaths = new HashSet<FinderPath>();
        finderPaths.addAll(this._getFinderPaths(this._getCacheNameWithoutPagination(className)));
        finderPaths.addAll(this._getFinderPaths(className));
        ArgumentsResolver argumentsResolver = argumentsResolverHolder.getArgumentsResolver();
        for (FinderPath finderPath : finderPaths) {
            if (baseModel.isNew()) {
                this._removeResult(finderPath, argumentsResolver.getArguments(finderPath, baseModel, false, false));
                continue;
            }
            this._removeResult(finderPath, argumentsResolver.getArguments(finderPath, baseModel, true, false));
            this._removeResult(finderPath, argumentsResolver.getArguments(finderPath, baseModel, true, true));
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._valueObjectFinderCacheEnabled = GetterUtil.getBoolean((String)this._props.get("value.object.finder.cache.enabled"));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)this._props.get("value.object.finder.cache.list.threshold"));
        if (this._valueObjectFinderCacheListThreshold == 0) {
            this._valueObjectFinderCacheEnabled = false;
        }
        int localCacheMaxSize = GetterUtil.getInteger((String)this._props.get("value.object.finder.thread.local.cache.max.size"));
        this._localCache = !DBPartition.isPartitionEnabled() && localCacheMaxSize > 0 ? new CentralizedThreadLocal(FinderCacheImpl.class + "._localCache", () -> new LRUMap(localCacheMaxSize)) : null;
        PortalCacheManager portalCacheManager = this._multiVMPool.getPortalCacheManager();
        portalCacheManager.registerPortalCacheManagerListener((PortalCacheManagerListener)this);
        this._serviceRegistration = bundleContext.registerService(CacheRegistryItem.class, (Object)new FinderCacheCacheRegistryItem(), null);
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ArgumentsResolver.class, (String)"class.name", (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ArgumentsResolver, ArgumentsResolverHolder>(){

            public ArgumentsResolverHolder addingService(ServiceReference<ArgumentsResolver> serviceReference) {
                ArgumentsResolverHolder argumentsResolverHolder = new ArgumentsResolverHolder(serviceReference);
                FinderCacheImpl.this._argumentsResolverHolderMap.put(argumentsResolverHolder.getTableName(), argumentsResolverHolder);
                return argumentsResolverHolder;
            }

            public void modifiedService(ServiceReference<ArgumentsResolver> serviceReference, ArgumentsResolverHolder argumentsResolverHolder) {
            }

            public void removedService(ServiceReference<ArgumentsResolver> serviceReference, ArgumentsResolverHolder argumentsResolverHolder) {
                FinderCacheImpl.this._argumentsResolverHolderMap.remove(argumentsResolverHolder.getTableName());
                argumentsResolverHolder.ungetArgumentsResolver();
            }
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    private void _clearCache(String cacheName) {
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(cacheName);
        portalCache.removeAll();
    }

    private void _clearDSLQueryCache(String className) {
        ArgumentsResolverHolder argumentsResolverHolder = (ArgumentsResolverHolder)this._serviceTrackerMap.getService((Object)className);
        String tableName = null;
        tableName = argumentsResolverHolder == null ? className : argumentsResolverHolder.getTableName();
        Set<String> dslQueryCacheNames = this._dslQueryCacheNamesMap.get(tableName);
        if (dslQueryCacheNames != null) {
            this.clearLocalCache();
            for (String dslQueryCacheName : dslQueryCacheNames) {
                this._clearCache(dslQueryCacheName);
            }
        }
    }

    private Serializable _encodeCacheKey(FinderPath finderPath, Object[] arguments) {
        CacheKeyGenerator cacheKeyGenerator = this._getCacheKeyGenerator(finderPath.isBaseModelResult());
        String[] keys = new String[arguments.length * 2];
        for (int i = 0; i < arguments.length; ++i) {
            int index = i * 2;
            keys[index] = ".";
            keys[index + 1] = StringUtil.toHexString((Object)arguments[i]);
        }
        return cacheKeyGenerator.getCacheKey(new String[]{finderPath.getCacheKeyPrefix(), StringUtil.toHexString((Object)cacheKeyGenerator.getCacheKey(keys))});
    }

    private CacheKeyGenerator _getCacheKeyGenerator(boolean baseModel) {
        if (baseModel) {
            CacheKeyGenerator cacheKeyGenerator = this._baseModelCacheKeyGenerator;
            if (cacheKeyGenerator == null) {
                this._baseModelCacheKeyGenerator = cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)(FinderCache.class.getName() + "#BaseModel"));
            }
            return cacheKeyGenerator;
        }
        CacheKeyGenerator cacheKeyGenerator = this._cacheKeyGenerator;
        if (cacheKeyGenerator == null) {
            this._cacheKeyGenerator = cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator((String)FinderCache.class.getName());
        }
        return cacheKeyGenerator;
    }

    private String _getCacheNameWithoutPagination(String cacheName) {
        return cacheName.concat(".List2");
    }

    private String _getCacheNameWithPagination(String cacheName) {
        return cacheName.concat(".List1");
    }

    private Collection<FinderPath> _getFinderPaths(String cacheName) {
        Map<String, FinderPath> finderPaths = this._finderPathsMap.get(cacheName);
        if (finderPaths == null) {
            return Collections.emptySet();
        }
        return finderPaths.values();
    }

    private PortalCache<Serializable, Serializable> _getPortalCache(String className) {
        PortalCache<Serializable, Serializable> previousPortalCache;
        boolean sharded;
        boolean ctAware;
        String groupKey;
        PortalCache portalCache;
        block12: {
            portalCache = (PortalCache)this._portalCaches.get(className);
            if (portalCache != null) {
                return portalCache;
            }
            groupKey = _GROUP_KEY_PREFIX.concat(className);
            String modelImplClassName = className;
            if (className.endsWith(".List1") || className.endsWith(".List2")) {
                modelImplClassName = className.substring(0, className.length() - 6);
            }
            ctAware = false;
            sharded = false;
            ArgumentsResolverHolder argumentsResolverHolder = (ArgumentsResolverHolder)this._serviceTrackerMap.getService((Object)modelImplClassName);
            if (argumentsResolverHolder != null) {
                ArgumentsResolver argumentsResolver = argumentsResolverHolder.getArgumentsResolver();
                if (!Objects.equals(argumentsResolver.getClassName(), argumentsResolver.getTableName())) {
                    Class<?> clazz = argumentsResolver.getClass();
                    ClassLoader classLoader = clazz.getClassLoader();
                    try {
                        Class<?> modelImplClass = classLoader.loadClass(argumentsResolver.getClassName());
                        if (DBPartition.isPartitionEnabled()) {
                            sharded = DBPartition.isPartitionedModel(modelImplClass);
                        }
                        ctAware = CTModel.class.isAssignableFrom(modelImplClass);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!_log.isWarnEnabled()) break block12;
                        _log.warn((Throwable)classNotFoundException);
                    }
                }
            } else {
                String[] tableNames;
                for (String tableName : tableNames = FinderPath.decodeDSLQueryCacheName((String)className)) {
                    ArgumentsResolver argumentsResolver;
                    argumentsResolverHolder = this._argumentsResolverHolderMap.get(tableName);
                    if (argumentsResolverHolder == null || Objects.equals((argumentsResolver = argumentsResolverHolder.getArgumentsResolver()).getClassName(), argumentsResolver.getTableName())) continue;
                    Class<?> clazz = argumentsResolver.getClass();
                    ClassLoader classLoader = clazz.getClassLoader();
                    try {
                        Class<?> modelImplClass = classLoader.loadClass(argumentsResolver.getClassName());
                        ctAware = CTModel.class.isAssignableFrom(modelImplClass);
                        if (!ctAware) continue;
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Throwable)classNotFoundException);
                    }
                }
            }
        }
        if ((previousPortalCache = this._portalCaches.putIfAbsent(className, (PortalCache<Serializable, Serializable>)(portalCache = ctAware ? new CTAwarePortalCache(this._multiVMPool, groupKey, false, sharded) : this._multiVMPool.getPortalCache(groupKey, false, sharded)))) != null) {
            return previousPortalCache;
        }
        return portalCache;
    }

    private boolean _isLocalCacheEnabled() {
        if (this._localCache == null || !CTCollectionThreadLocal.isProductionMode()) {
            return false;
        }
        return ThreadLocalFilterThreadLocal.isFilterInvoked();
    }

    private void _removeResult(FinderPath finderPath, Object[] args) {
        if (args == null) {
            return;
        }
        Serializable cacheKey = this._encodeCacheKey(finderPath, args);
        if (this._isLocalCacheEnabled()) {
            Map localCache = (Map)this._localCache.get();
            localCache.remove(new LocalCacheKey(finderPath.getCacheName(), cacheKey));
        }
        PortalCache<Serializable, Serializable> portalCache = this._getPortalCache(finderPath.getCacheName());
        portalCache.remove(cacheKey);
    }

    private class FinderCacheCacheRegistryItem
    implements CacheRegistryItem {
        private FinderCacheCacheRegistryItem() {
        }

        public String getRegistryName() {
            return FinderCache.class.getName();
        }

        public void invalidate() {
            FinderCacheImpl.this.clearCache();
        }
    }

    private class ArgumentsResolverHolder {
        private final DCLSingleton<ArgumentsResolver> _argumentsResolverDCLSingleton = new DCLSingleton();
        private final ServiceReference<ArgumentsResolver> _serviceReference;

        public ArgumentsResolver getArgumentsResolver() {
            return (ArgumentsResolver)this._argumentsResolverDCLSingleton.getSingleton(() -> (ArgumentsResolver)FinderCacheImpl.this._bundleContext.getService(this._serviceReference));
        }

        public String getTableName() {
            return (String)this._serviceReference.getProperty("table.name");
        }

        public void ungetArgumentsResolver() {
            this._argumentsResolverDCLSingleton.destroy(argumentsResolver -> FinderCacheImpl.this._bundleContext.ungetService(this._serviceReference));
        }

        private ArgumentsResolverHolder(ServiceReference<ArgumentsResolver> serviceReference) {
            this._serviceReference = serviceReference;
        }
    }

    private static class LocalCacheKey {
        private final Serializable _cacheKey;
        private final String _className;

        public boolean equals(Object object) {
            LocalCacheKey localCacheKey = (LocalCacheKey)object;
            return this._className.equals(localCacheKey._className) && this._cacheKey.equals(localCacheKey._cacheKey);
        }

        public int hashCode() {
            return HashUtil.hash((int)this._className.hashCode(), (int)this._cacheKey.hashCode());
        }

        private LocalCacheKey(String className, Serializable cacheKey) {
            this._className = className;
            this._cacheKey = cacheKey;
        }
    }
}

