/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.internal.dao.orm;

import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CTAwarePortalCache
implements PortalCache<Serializable, Serializable> {
    private static final String _CHANGE_TRACKING_POSTFIX = ".CT#";
    private final Map<Long, PortalCache<Serializable, Serializable>> _ctPortalCaches = new ConcurrentHashMap<Long, PortalCache<Serializable, Serializable>>();
    private final MultiVMPool _multiVMPool;
    private final boolean _mvcc;
    private final String _portalCacheName;
    private final PortalCache<Serializable, Serializable> _productionPortalCache;
    private final boolean _sharded;

    public CTAwarePortalCache(MultiVMPool multiVMPool, String portalCacheName, boolean mvcc, boolean sharded) {
        this._multiVMPool = multiVMPool;
        this._portalCacheName = portalCacheName;
        this._mvcc = mvcc;
        this._sharded = sharded;
        this._productionPortalCache = multiVMPool.getPortalCache(portalCacheName, mvcc, sharded);
    }

    public void destroy() {
        this._multiVMPool.removePortalCache(this._productionPortalCache.getPortalCacheName());
        for (PortalCache<Serializable, Serializable> ctPortalCache : this._ctPortalCaches.values()) {
            this._multiVMPool.removePortalCache(ctPortalCache.getPortalCacheName());
        }
        this._ctPortalCaches.clear();
    }

    public Serializable get(Serializable key) {
        PortalCache<Serializable, Serializable> portalCache = this._getCTPortalCache();
        return (Serializable)portalCache.get(key);
    }

    public List<Serializable> getKeys() {
        throw new UnsupportedOperationException();
    }

    public PortalCacheManager<Serializable, Serializable> getPortalCacheManager() {
        return this._productionPortalCache.getPortalCacheManager();
    }

    public String getPortalCacheName() {
        return this._portalCacheName;
    }

    public PortalCache<Serializable, Serializable> getProductionPortalCache() {
        return this._productionPortalCache;
    }

    public boolean isMVCC() {
        return this._mvcc;
    }

    public boolean isSharded() {
        return this._sharded;
    }

    public void put(Serializable key, Serializable value) {
        this.put(key, value, 0);
    }

    public void put(Serializable key, Serializable value, int timeToLive) {
        PortalCache<Serializable, Serializable> portalCache = this._getCTPortalCache();
        portalCache.put(key, (Object)value, timeToLive);
    }

    public void registerPortalCacheListener(PortalCacheListener<Serializable, Serializable> portalCacheListener) {
        throw new UnsupportedOperationException();
    }

    public void registerPortalCacheListener(PortalCacheListener<Serializable, Serializable> portalCacheListener, PortalCacheListenerScope portalCacheListenerScope) {
        throw new UnsupportedOperationException();
    }

    public void remove(Serializable key) {
        PortalCache<Serializable, Serializable> portalCache = this._getCTPortalCache();
        portalCache.remove(key);
        if (CTCollectionThreadLocal.isProductionMode()) {
            for (PortalCache<Serializable, Serializable> ctPortalCache : this._ctPortalCaches.values()) {
                ctPortalCache.remove(key);
            }
        }
    }

    public void removeAll() {
        PortalCache<Serializable, Serializable> portalCache = this._getCTPortalCache();
        portalCache.removeAll();
        if (CTCollectionThreadLocal.isProductionMode()) {
            for (PortalCache<Serializable, Serializable> ctPortalCache : this._ctPortalCaches.values()) {
                ctPortalCache.removeAll();
            }
        }
    }

    public void unregisterPortalCacheListener(PortalCacheListener<Serializable, Serializable> portalCacheListener) {
        throw new UnsupportedOperationException();
    }

    public void unregisterPortalCacheListeners() {
        throw new UnsupportedOperationException();
    }

    private PortalCache<Serializable, Serializable> _getCTPortalCache() {
        long ctCollectionId = CTCollectionThreadLocal.getCTCollectionId();
        if (ctCollectionId == 0L) {
            return this._productionPortalCache;
        }
        PortalCache ctPortalCache = this._ctPortalCaches.get(ctCollectionId);
        if (ctPortalCache != null) {
            return ctPortalCache;
        }
        ctPortalCache = this._multiVMPool.getPortalCache(this._portalCacheName + _CHANGE_TRACKING_POSTFIX + ctCollectionId, this._mvcc, this._sharded);
        PortalCache<Serializable, Serializable> previousCTPortalCache = this._ctPortalCaches.putIfAbsent(ctCollectionId, (PortalCache<Serializable, Serializable>)ctPortalCache);
        if (previousCTPortalCache != null) {
            return previousCTPortalCache;
        }
        return ctPortalCache;
    }
}

