/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;

@Component(service={})
public class PortalCacheExtender {
    private static final Log _log = LogFactoryUtil.getLog(PortalCacheExtender.class);
    private BundleTracker<Void> _bundleTracker;
    @Reference(target="(portal.cache.manager.name=MULTI_VM_PORTAL_CACHE_MANAGER)")
    private PortalCacheManager<? extends Serializable, ? extends Serializable> _multiVMPortalCacheManager;
    @Reference(target="(portal.cache.manager.name=SINGLE_VM_PORTAL_CACHE_MANAGER)")
    private PortalCacheManager<? extends Serializable, ?> _singleVMPortalCacheManager;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleTracker = new BundleTracker<Void>(bundleContext, 32, null){

            public Void addingBundle(Bundle bundle, BundleEvent bundleEvent) {
                BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
                ClassLoader classLoader = bundleWiring.getClassLoader();
                PortalCacheExtender.this._configure(PortalCacheExtender.this._getURL(classLoader, "ehcache.multi.vm.config.location", "/META-INF/module-multi-vm.xml"), classLoader, PortalCacheExtender.this._multiVMPortalCacheManager);
                PortalCacheExtender.this._configure(PortalCacheExtender.this._getURL(bundle.getSymbolicName(), "-multi-vm-ext.xml"), classLoader, PortalCacheExtender.this._multiVMPortalCacheManager);
                PortalCacheExtender.this._configure(PortalCacheExtender.this._getURL(classLoader, "ehcache.single.vm.config.location", "/META-INF/module-single-vm.xml"), classLoader, PortalCacheExtender.this._singleVMPortalCacheManager);
                PortalCacheExtender.this._configure(PortalCacheExtender.this._getURL(bundle.getSymbolicName(), "-single-vm-ext.xml"), classLoader, PortalCacheExtender.this._singleVMPortalCacheManager);
                return null;
            }
        };
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
    }

    private void _configure(URL configurationURL, ClassLoader classLoader, PortalCacheManager<?, ?> portalCacheManager) {
        if (configurationURL == null) {
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Reconfiguring caches in cache manager ", portalCacheManager.getPortalCacheManagerName(), " using ", configurationURL}));
        }
        portalCacheManager.reconfigurePortalCaches(configurationURL, classLoader);
    }

    private URL _getURL(ClassLoader classLoader, String propertyKey, String defaultConfigurationFile) {
        String configurationFile = null;
        if (classLoader.getResource("portlet.properties") != null) {
            Configuration configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"portlet");
            configurationFile = configuration.get(propertyKey);
        }
        if (Validator.isNull(configurationFile)) {
            configurationFile = defaultConfigurationFile;
        }
        return classLoader.getResource(configurationFile);
    }

    private URL _getURL(String symbolicName, String postfix) {
        File configFile = new File(StringBundler.concat((String[])new String[]{PropsValues.MODULE_FRAMEWORK_BASE_DIR, "/ehcache/", symbolicName, postfix}));
        if (!configFile.exists()) {
            return null;
        }
        URI uri = configFile.toURI();
        try {
            return uri.toURL();
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            return null;
        }
    }
}

