/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal;

import com.liferay.portal.cache.ehcache.internal.BaseEhcachePortalCache;
import com.liferay.portal.cache.ehcache.internal.EhcachePortalCacheConfiguration;
import com.liferay.portal.cache.ehcache.internal.EhcachePortalCacheManager;
import com.liferay.portal.cache.ehcache.internal.event.PortalCacheCacheEventListener;
import com.liferay.portal.db.partition.DBPartitionUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.event.NotificationScope;
import net.sf.ehcache.event.RegisteredEventListeners;

public class ShardedEhcachePortalCache<K extends Serializable, V>
extends BaseEhcachePortalCache<K, V> {
    private static final String _SHARDED_SEPARATOR = "_SHARDED_SEPARATOR_";
    private final CacheManager _cacheManager;
    private final Map<Long, Ehcache> _ehcaches = new ConcurrentHashMap<Long, Ehcache>();

    public ShardedEhcachePortalCache(EhcachePortalCacheManager<K, V> ehcachePortalCacheManager, EhcachePortalCacheConfiguration ehcachePortalCacheConfiguration) {
        super(ehcachePortalCacheManager, ehcachePortalCacheConfiguration);
        this._cacheManager = ehcachePortalCacheManager.getEhcacheManager();
    }

    @Override
    public Ehcache getEhcache() {
        long companyId = DBPartitionUtil.getCurrentCompanyId();
        return this._ehcaches.computeIfAbsent(companyId, key -> {
            String shardedPortalCacheName = this.getPortalCacheName() + _SHARDED_SEPARATOR + key;
            CacheManager cacheManager = this._cacheManager;
            synchronized (cacheManager) {
                if (!this._cacheManager.cacheExists(shardedPortalCacheName)) {
                    if (this._cacheManager.cacheExists(this.getPortalCacheName())) {
                        Cache cache = this._cacheManager.getCache(this.getPortalCacheName());
                        CacheConfiguration cacheConfiguration = cache.getCacheConfiguration();
                        CacheConfiguration clonedCacheConfiguration = cacheConfiguration.clone();
                        clonedCacheConfiguration.setName(shardedPortalCacheName);
                        this._cacheManager.addCache(new Cache(clonedCacheConfiguration));
                    } else {
                        this._cacheManager.addCache(shardedPortalCacheName);
                    }
                }
            }
            Cache ehcache = this._cacheManager.getCache(shardedPortalCacheName);
            RegisteredEventListeners registeredEventListeners = ehcache.getCacheEventNotificationService();
            registeredEventListeners.registerListener(new PortalCacheCacheEventListener(this.aggregatedPortalCacheListener, this), NotificationScope.ALL);
            return ehcache;
        });
    }

    public boolean isSharded() {
        return true;
    }

    @Override
    protected void dispose() {
        this._cacheManager.removeCache(this.getPortalCacheName());
        for (Ehcache ehcache : this._ehcaches.values()) {
            this._cacheManager.removeCache(ehcache.getName());
        }
    }

    protected void removeEhcache(long companyId) {
        Ehcache ehcache = this._ehcaches.remove(companyId);
        if (ehcache == null) {
            return;
        }
        this._cacheManager.removeCache(ehcache.getName());
    }

    @Override
    protected void resetEhcache() {
        this._ehcaches.clear();
    }
}

