/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal;

import com.liferay.portal.cache.BasePortalCache;
import com.liferay.portal.cache.ehcache.internal.EhcachePortalCacheConfiguration;
import com.liferay.portal.cache.ehcache.internal.EhcachePortalCacheManager;
import com.liferay.portal.cache.ehcache.internal.EhcacheWrapper;
import com.liferay.portal.cache.io.SerializableObjectWrapper;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheListenerScope;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public abstract class BaseEhcachePortalCache<K extends Serializable, V>
extends BasePortalCache<K, V>
implements EhcacheWrapper {
    private final String _portalCacheName;
    private final boolean _serializable;

    public BaseEhcachePortalCache(EhcachePortalCacheManager<K, V> ehcachePortalCacheManager, EhcachePortalCacheConfiguration ehcachePortalCacheConfiguration) {
        super(ehcachePortalCacheManager);
        this._portalCacheName = ehcachePortalCacheConfiguration.getPortalCacheName();
        this._serializable = ehcachePortalCacheConfiguration.isRequireSerialization();
    }

    public List<K> getKeys() {
        Ehcache ehcache = this.getEhcache();
        List rawKeys = ehcache.getKeys();
        if (!this._serializable) {
            return rawKeys;
        }
        if (rawKeys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> keys = new ArrayList<Object>(rawKeys.size());
        for (Object object : rawKeys) {
            keys.add(SerializableObjectWrapper.unwrap(object));
        }
        return keys;
    }

    public String getPortalCacheName() {
        return this._portalCacheName;
    }

    public boolean isSerializable() {
        return this._serializable;
    }

    public void removeAll() {
        Ehcache ehcache = this.getEhcache();
        ehcache.removeAll();
    }

    protected abstract void dispose();

    protected V doGet(K key) {
        Ehcache ehcache = this.getEhcache();
        if (this._serializable) {
            return this._getValue(ehcache.get((Serializable)new SerializableObjectWrapper(key)));
        }
        return this._getValue(ehcache.get(key));
    }

    protected void doPut(K key, V value, int timeToLive) {
        Ehcache ehcache = this.getEhcache();
        ehcache.put(this._createElement(key, value, timeToLive));
    }

    protected V doPutIfAbsent(K key, V value, int timeToLive) {
        Ehcache ehcache = this.getEhcache();
        return this._getValue(ehcache.putIfAbsent(this._createElement(key, value, timeToLive)));
    }

    protected void doRemove(K key) {
        Ehcache ehcache = this.getEhcache();
        if (this._serializable) {
            ehcache.remove((Serializable)new SerializableObjectWrapper(key));
        } else {
            ehcache.remove(key);
        }
    }

    protected boolean doRemove(K key, V value) {
        Ehcache ehcache = this.getEhcache();
        return ehcache.removeElement(this._createElement(key, value, 0));
    }

    protected V doReplace(K key, V value, int timeToLive) {
        Ehcache ehcache = this.getEhcache();
        return this._getValue(ehcache.replace(this._createElement(key, value, timeToLive)));
    }

    protected boolean doReplace(K key, V oldValue, V newValue, int timeToLive) {
        Ehcache ehcache = this.getEhcache();
        return ehcache.replace(this._createElement(key, oldValue, 0), this._createElement(key, newValue, timeToLive));
    }

    protected Map<PortalCacheListener<K, V>, PortalCacheListenerScope> getPortalCacheListeners() {
        return this.aggregatedPortalCacheListener.getPortalCacheListeners();
    }

    protected abstract void resetEhcache();

    private Element _createElement(K key, V value, int timeToLive) {
        Element element = null;
        if (this._serializable) {
            Object objectValue = value;
            if (value instanceof Serializable) {
                objectValue = new SerializableObjectWrapper((Serializable)value);
            }
            element = new Element((Object)new SerializableObjectWrapper(key), objectValue);
        } else {
            element = new Element(key, value);
        }
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        return element;
    }

    private V _getValue(Element element) {
        if (element == null) {
            return null;
        }
        if (this._serializable) {
            return (V)SerializableObjectWrapper.unwrap((Object)element.getObjectValue());
        }
        return (V)element.getObjectValue();
    }
}

