/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal;

import com.liferay.portal.cache.BasePortalCache;
import com.liferay.portal.cache.ehcache.internal.EhcacheWrapper;
import com.liferay.portal.cache.ehcache.internal.event.PortalCacheCacheEventListener;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.NotificationScope;
import net.sf.ehcache.event.RegisteredEventListeners;

public class EhcachePortalCache<K extends Serializable, V>
extends BasePortalCache<K, V>
implements EhcacheWrapper {
    protected volatile Ehcache ehcache;

    public EhcachePortalCache(PortalCacheManager<K, V> portalCacheManager, Ehcache ehcache) {
        super(portalCacheManager);
        this.ehcache = ehcache;
        RegisteredEventListeners registeredEventListeners = ehcache.getCacheEventNotificationService();
        registeredEventListeners.registerListener(new PortalCacheCacheEventListener(this.aggregatedPortalCacheListener, this), NotificationScope.ALL);
    }

    @Override
    public Ehcache getEhcache() {
        return this.ehcache;
    }

    public List<K> getKeys() {
        return this.ehcache.getKeys();
    }

    public String getPortalCacheName() {
        return this.ehcache.getName();
    }

    public void removeAll() {
        this.ehcache.removeAll();
    }

    protected V doGet(K key) {
        Element element = this.ehcache.get(key);
        if (element == null) {
            return null;
        }
        return (V)element.getObjectValue();
    }

    protected void doPut(K key, V value, int timeToLive) {
        Element element = new Element(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        this.ehcache.put(element);
    }

    protected V doPutIfAbsent(K key, V value, int timeToLive) {
        Element oldElement;
        Element element = new Element(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        if ((oldElement = this.ehcache.putIfAbsent(element)) == null) {
            return null;
        }
        return (V)oldElement.getObjectValue();
    }

    protected void doRemove(K key) {
        this.ehcache.remove(key);
    }

    protected boolean doRemove(K key, V value) {
        Element element = new Element(key, value);
        return this.ehcache.removeElement(element);
    }

    protected V doReplace(K key, V value, int timeToLive) {
        Element oldElement;
        Element element = new Element(key, value);
        if (timeToLive != 0) {
            element.setTimeToLive(timeToLive);
        }
        if ((oldElement = this.ehcache.replace(element)) == null) {
            return null;
        }
        return (V)oldElement.getObjectValue();
    }

    protected boolean doReplace(K key, V oldValue, V newValue, int timeToLive) {
        Element oldElement = new Element(key, oldValue);
        Element newElement = new Element(key, newValue);
        if (timeToLive != 0) {
            newElement.setTimeToLive(timeToLive);
        }
        return this.ehcache.replace(oldElement, newElement);
    }

    protected Map<PortalCacheListener<K, V>, PortalCacheListenerScope> getPortalCacheListeners() {
        return Collections.unmodifiableMap(this.aggregatedPortalCacheListener.getPortalCacheListeners());
    }

    protected void reconfigEhcache(Ehcache ehcache) {
        RegisteredEventListeners registeredEventListeners = ehcache.getCacheEventNotificationService();
        registeredEventListeners.registerListener(new PortalCacheCacheEventListener(this.aggregatedPortalCacheListener, this), NotificationScope.ALL);
        Ehcache oldEhcache = this.ehcache;
        this.ehcache = ehcache;
        registeredEventListeners = oldEhcache.getCacheEventNotificationService();
        Set cacheEventListeners = registeredEventListeners.getCacheEventListeners();
        for (CacheEventListener cacheEventListener : cacheEventListeners) {
            registeredEventListeners.unregisterListener(cacheEventListener);
        }
    }
}

