/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal;

import com.liferay.portal.cache.PortalCacheListenerFactory;
import com.liferay.portal.cache.PortalCacheManagerListenerFactory;
import com.liferay.portal.cache.ehcache.internal.EhcachePortalCacheManager;
import com.liferay.portal.cache.ehcache.internal.configurator.MultiVMEhcachePortalCacheManagerConfigurator;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Props;
import java.io.Serializable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"portal.cache.manager.name=MULTI_VM_PORTAL_CACHE_MANAGER"}, service={PortalCacheManager.class})
public class MultiVMEhcachePortalCacheManager<K extends Serializable, V extends Serializable>
extends EhcachePortalCacheManager<K, V> {
    private static final String _DEFAULT_CONFIG_FILE_NAME = "/ehcache/liferay-multi-vm.xml";
    private static final Log _log = LogFactoryUtil.getLog(MultiVMEhcachePortalCacheManager.class);

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.setClusterAware(true);
        this.setConfigFile(this.props.get("ehcache.multi.vm.config.location"));
        this.setDefaultConfigFile(_DEFAULT_CONFIG_FILE_NAME);
        this.setMpiOnly(true);
        this.setPortalCacheManagerName("MULTI_VM_PORTAL_CACHE_MANAGER");
        this.initialize();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Activated MULTI_VM_PORTAL_CACHE_MANAGER");
        }
    }

    @Deactivate
    protected void deactivate() {
        this.destroy();
    }

    @Reference(unbind="-")
    protected void setMultiVMEhcachePortalCacheManagerConfigurator(MultiVMEhcachePortalCacheManagerConfigurator multiVMEhcachePortalCacheManagerConfigurator) {
        this.baseEhcachePortalCacheManagerConfigurator = multiVMEhcachePortalCacheManagerConfigurator;
    }

    @Reference(unbind="-")
    protected void setPortalCacheListenerFactory(PortalCacheListenerFactory portalCacheListenerFactory) {
        this.portalCacheListenerFactory = portalCacheListenerFactory;
    }

    @Reference(unbind="-")
    protected void setPortalCacheManagerListenerFactory(PortalCacheManagerListenerFactory<PortalCacheManager<K, V>> portalCacheManagerListenerFactory) {
        this.portalCacheManagerListenerFactory = portalCacheManagerListenerFactory;
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this.props = props;
    }
}

