/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal.event;

import com.liferay.portal.cache.PortalCacheListenerFactory;
import com.liferay.portal.cache.PortalCacheReplicator;
import com.liferay.portal.cache.PortalCacheReplicatorFactory;
import com.liferay.portal.cache.ehcache.spi.event.ConfigurableEhcachePortalCacheListener;
import com.liferay.portal.cache.ehcache.spi.event.EhcachePortalCacheListenerAdapter;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Properties;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalCacheListenerFactory.class})
public class EhcachePortalCacheListenerFactory
implements PortalCacheListenerFactory {
    private PortalCacheReplicatorFactory _portalCacheReplicatorFactory;

    public <K extends Serializable, V> PortalCacheListener<K, V> create(Properties properties) {
        boolean replicator = GetterUtil.getBoolean((Object)properties.get("replicator"));
        if (replicator) {
            PortalCacheReplicator portalCacheListener = this._portalCacheReplicatorFactory.create(properties);
            if (portalCacheListener == null) {
                return null;
            }
            return new EhcachePortalCacheReplicator(portalCacheListener);
        }
        String className = (String)properties.remove("CACHE_LISTENER_PROPERTIES_KEY_FACTORY_CLASS_NAME");
        if (Validator.isNull((String)className)) {
            return null;
        }
        ClassLoader classLoader = (ClassLoader)properties.remove("CACHE_LISTENER_PROPERTIES_KEY_FACTORY_CLASS_LOADER");
        if (classLoader == null) {
            return null;
        }
        try {
            CacheEventListenerFactory cacheEventListenerFactory = (CacheEventListenerFactory)InstanceFactory.newInstance((ClassLoader)classLoader, (String)className);
            CacheEventListener cacheEventListener = cacheEventListenerFactory.createCacheEventListener(properties);
            return new EhcachePortalCacheListenerAdapter(cacheEventListener);
        }
        catch (Exception e) {
            throw new SystemException("Unable to instantiate cache event listener factory " + className, (Throwable)e);
        }
    }

    @Reference(unbind="-")
    protected void setPortalCacheReplicatorFactory(PortalCacheReplicatorFactory portalCacheReplicatorFactory) {
        this._portalCacheReplicatorFactory = portalCacheReplicatorFactory;
    }

    private class EhcachePortalCacheReplicator<K extends Serializable, V extends Serializable>
    implements PortalCacheReplicator<K, V>,
    ConfigurableEhcachePortalCacheListener {
        private final PortalCacheReplicator<K, V> _portalCacheReplicator;

        public void dispose() {
            this._portalCacheReplicator.dispose();
        }

        public void notifyEntryEvicted(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
            this._portalCacheReplicator.notifyEntryEvicted(portalCache, key, value, timeToLive);
        }

        public void notifyEntryExpired(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
            this._portalCacheReplicator.notifyEntryExpired(portalCache, key, value, timeToLive);
        }

        public void notifyEntryPut(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
            this._portalCacheReplicator.notifyEntryPut(portalCache, key, value, timeToLive);
        }

        public void notifyEntryRemoved(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
            this._portalCacheReplicator.notifyEntryRemoved(portalCache, key, value, timeToLive);
        }

        public void notifyEntryUpdated(PortalCache<K, V> portalCache, K key, V value, int timeToLive) throws PortalCacheException {
            this._portalCacheReplicator.notifyEntryUpdated(portalCache, key, value, timeToLive);
        }

        public void notifyRemoveAll(PortalCache<K, V> portalCache) throws PortalCacheException {
            this._portalCacheReplicator.notifyRemoveAll(portalCache);
        }

        private EhcachePortalCacheReplicator(PortalCacheReplicator<K, V> portalCacheReplicator) {
            this._portalCacheReplicator = portalCacheReplicator;
        }
    }
}

