/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache.internal.configurator;

import com.liferay.portal.cache.configuration.PortalCacheConfiguration;
import com.liferay.portal.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.cache.ehcache.internal.configurator.BaseEhcachePortalCacheManagerConfigurator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={MultiVMEhcachePortalCacheManagerConfigurator.class})
public class MultiVMEhcachePortalCacheManagerConfigurator
extends BaseEhcachePortalCacheManagerConfigurator {
    protected boolean clusterEnabled;
    private boolean _bootstrapLoaderEnabled;
    private Properties _bootstrapLoaderProperties;
    private String _defaultBootstrapLoaderPropertiesString;
    private String _defaultReplicatorPropertiesString;
    private Properties _replicatorProperties;

    @Activate
    protected void activate() {
        this._bootstrapLoaderEnabled = GetterUtil.getBoolean((String)this.props.get("ehcache.bootstrap.cache.loader.enabled"));
        this._bootstrapLoaderProperties = this.props.getProperties("ehcache.bootstrap.cache.loader.properties.", true);
        this.clusterEnabled = GetterUtil.getBoolean((String)this.props.get("cluster.link.enabled"));
        this._defaultBootstrapLoaderPropertiesString = this.getPortalPropertiesString("ehcache.bootstrap.cache.loader.properties.default");
        this._defaultReplicatorPropertiesString = this.getPortalPropertiesString("ehcache.replicator.properties.default");
        this._replicatorProperties = this.props.getProperties("ehcache.replicator.properties.", true);
    }

    protected String getPortalPropertiesString(String portalPropertyKey) {
        String[] array = this.props.getArray(portalPropertyKey);
        if (array.length == 0) {
            return null;
        }
        if (array.length == 1) {
            return array[0];
        }
        StringBundler sb = new StringBundler(array.length * 2);
        for (String value : array) {
            sb.append(value);
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    @Override
    protected boolean isRequireSerialization(CacheConfiguration cacheConfiguration) {
        if (this.clusterEnabled) {
            return true;
        }
        return super.isRequireSerialization(cacheConfiguration);
    }

    @Override
    protected void manageConfiguration(Configuration configuration, PortalCacheManagerConfiguration portalCacheManagerConfiguration) {
        if (!this.clusterEnabled) {
            return;
        }
        PortalCacheConfiguration defaultPortalCacheConfiguration = portalCacheManagerConfiguration.getDefaultPortalCacheConfiguration();
        Map<String, ObjectValuePair<Properties, Properties>> mergedPropertiesMap = this._getMergedPropertiesMap();
        for (Map.Entry<String, ObjectValuePair<Properties, Properties>> entry : mergedPropertiesMap.entrySet()) {
            String portalCacheName = entry.getKey();
            PortalCacheConfiguration portalCacheConfiguration = portalCacheManagerConfiguration.getPortalCacheConfiguration(portalCacheName);
            if (portalCacheConfiguration == null) {
                portalCacheConfiguration = defaultPortalCacheConfiguration.newPortalCacheConfiguration(portalCacheName);
                portalCacheManagerConfiguration.putPortalCacheConfiguration(portalCacheName, portalCacheConfiguration);
            }
            ObjectValuePair<Properties, Properties> propertiesPair = entry.getValue();
            if (this._bootstrapLoaderEnabled && propertiesPair.getKey() != null) {
                portalCacheConfiguration.setPortalCacheBootstrapLoaderProperties((Properties)propertiesPair.getKey());
            }
            if (propertiesPair.getValue() == null) continue;
            Set portalCacheListenerPropertiesSet = portalCacheConfiguration.getPortalCacheListenerPropertiesSet();
            Iterator itr = portalCacheListenerPropertiesSet.iterator();
            while (itr.hasNext()) {
                Properties properties = (Properties)itr.next();
                if (!((Boolean)properties.get("replicator")).booleanValue()) continue;
                itr.remove();
            }
            portalCacheListenerPropertiesSet.add(propertiesPair.getValue());
        }
    }

    @Override
    protected PortalCacheConfiguration parseCacheListenerConfigurations(CacheConfiguration cacheConfiguration, boolean usingDefault) {
        String replicatorPropertiesString;
        PortalCacheConfiguration portalCacheConfiguration = super.parseCacheListenerConfigurations(cacheConfiguration, usingDefault);
        if (!this.clusterEnabled) {
            return portalCacheConfiguration;
        }
        String cacheName = cacheConfiguration.getName();
        if (this._bootstrapLoaderEnabled) {
            String bootstrapLoaderPropertiesString = (String)this._bootstrapLoaderProperties.remove(cacheName);
            if (Validator.isNull((String)bootstrapLoaderPropertiesString)) {
                bootstrapLoaderPropertiesString = this._defaultBootstrapLoaderPropertiesString;
            }
            portalCacheConfiguration.setPortalCacheBootstrapLoaderProperties(this.parseProperties(bootstrapLoaderPropertiesString, ","));
        }
        if (Validator.isNull((String)(replicatorPropertiesString = (String)this._replicatorProperties.remove(cacheName)))) {
            replicatorPropertiesString = this._defaultReplicatorPropertiesString;
        }
        Properties replicatorProperties = this.parseProperties(replicatorPropertiesString, ",");
        replicatorProperties.put("replicator", (Object)true);
        Set portalCacheListenerPropertiesSet = portalCacheConfiguration.getPortalCacheListenerPropertiesSet();
        portalCacheListenerPropertiesSet.add(replicatorProperties);
        return portalCacheConfiguration;
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this.props = props;
    }

    private Map<String, ObjectValuePair<Properties, Properties>> _getMergedPropertiesMap() {
        HashMap<String, ObjectValuePair<Properties, Properties>> mergedPropertiesMap = new HashMap<String, ObjectValuePair<Properties, Properties>>();
        if (this._bootstrapLoaderEnabled) {
            for (String portalCacheName : this._bootstrapLoaderProperties.stringPropertyNames()) {
                mergedPropertiesMap.put(portalCacheName, (ObjectValuePair<Properties, Properties>)new ObjectValuePair((Object)this.parseProperties(this._bootstrapLoaderProperties.getProperty(portalCacheName), ","), null));
            }
        }
        for (String portalCacheName : this._replicatorProperties.stringPropertyNames()) {
            Properties replicatorProperties = this.parseProperties(this._replicatorProperties.getProperty(portalCacheName), ",");
            replicatorProperties.put("replicator", (Object)true);
            ObjectValuePair objectValuePair = (ObjectValuePair)mergedPropertiesMap.get(portalCacheName);
            if (objectValuePair == null) {
                mergedPropertiesMap.put(portalCacheName, (ObjectValuePair<Properties, Properties>)new ObjectValuePair(null, (Object)replicatorProperties));
                continue;
            }
            objectValuePair.setValue((Object)replicatorProperties);
        }
        return mergedPropertiesMap;
    }
}

