/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.cache.AggregatedPortalCacheManagerListener;
import com.liferay.portal.cache.BlockingPortalCache;
import com.liferay.portal.cache.LowLevelCache;
import com.liferay.portal.cache.MVCCPortalCache;
import com.liferay.portal.cache.PortalCacheBootstrapLoaderFactory;
import com.liferay.portal.cache.PortalCacheListenerFactory;
import com.liferay.portal.cache.PortalCacheManagerListenerFactory;
import com.liferay.portal.cache.TransactionalPortalCache;
import com.liferay.portal.cache.configuration.PortalCacheConfiguration;
import com.liferay.portal.cache.configuration.PortalCacheManagerConfiguration;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class BasePortalCacheManager<K extends Serializable, V>
implements PortalCacheManager<K, V> {
    protected final AggregatedPortalCacheManagerListener aggregatedPortalCacheManagerListener = new AggregatedPortalCacheManagerListener();
    protected PortalCacheBootstrapLoaderFactory portalCacheBootstrapLoaderFactory;
    protected PortalCacheListenerFactory portalCacheListenerFactory;
    protected PortalCacheManagerListenerFactory<PortalCacheManager<K, V>> portalCacheManagerListenerFactory;
    protected final ConcurrentMap<String, PortalCache<K, V>> portalCaches = new ConcurrentHashMap<String, PortalCache<K, V>>();
    private boolean _blockingPortalCacheAllowed;
    private boolean _clusterAware;
    private PortalCacheConfiguration _defaultPortalCacheConfiguration;
    private boolean _mpiOnly;
    private PortalCacheManagerConfiguration _portalCacheManagerConfiguration;
    private String _portalCacheManagerName;
    private boolean _transactionalPortalCacheEnabled;
    private String[] _transactionalPortalCacheNames = StringPool.EMPTY_ARRAY;

    public void clearAll() throws PortalCacheException {
        this.doClearAll();
    }

    public void destroy() {
        this.portalCaches.clear();
        this.doDestroy();
    }

    public PortalCache<K, V> fetchPortalCache(String portalCacheName) {
        return (PortalCache)this.portalCaches.get(portalCacheName);
    }

    public PortalCache<K, V> getPortalCache(String portalCacheName) throws PortalCacheException {
        return this.getPortalCache(portalCacheName, false);
    }

    public PortalCache<K, V> getPortalCache(String portalCacheName, boolean blocking) throws PortalCacheException {
        return this.getPortalCache(portalCacheName, blocking, false);
    }

    public PortalCache<K, V> getPortalCache(String portalCacheName, boolean blocking, boolean mvcc) throws PortalCacheException {
        PortalCache<K, V> previousPortalCache;
        PortalCache<K, V> portalCache = (PortalCache<K, V>)this.portalCaches.get(portalCacheName);
        if (portalCache != null) {
            this._verifyPortalCache(portalCache, blocking, mvcc);
            return portalCache;
        }
        PortalCacheConfiguration portalCacheConfiguration = this._portalCacheManagerConfiguration.getPortalCacheConfiguration(portalCacheName);
        if (portalCacheConfiguration == null) {
            portalCacheConfiguration = this._defaultPortalCacheConfiguration.newPortalCacheConfiguration(portalCacheName);
            this._portalCacheManagerConfiguration.putPortalCacheConfiguration(portalCacheName, portalCacheConfiguration);
        }
        portalCache = this.createPortalCache(portalCacheConfiguration);
        this._initPortalCacheListeners(portalCache, portalCacheConfiguration);
        if (mvcc) {
            portalCache = new MVCCPortalCache((LowLevelCache)portalCache);
        }
        if (this.isTransactionalPortalCacheEnabled() && this.isTransactionalPortalCache(portalCacheName)) {
            portalCache = new TransactionalPortalCache<K, V>(portalCache, mvcc);
        }
        if (this.isBlockingPortalCacheAllowed() && blocking) {
            portalCache = new BlockingPortalCache<K, V>(portalCache);
        }
        if ((previousPortalCache = this.portalCaches.putIfAbsent(portalCacheName, portalCache)) != null) {
            this._verifyPortalCache(portalCache, blocking, mvcc);
            portalCache = previousPortalCache;
        }
        return portalCache;
    }

    public Set<PortalCacheManagerListener> getPortalCacheManagerListeners() {
        return this.aggregatedPortalCacheManagerListener.getPortalCacheManagerListeners();
    }

    public String getPortalCacheManagerName() {
        return this._portalCacheManagerName;
    }

    public String[] getTransactionalPortalCacheNames() {
        return this._transactionalPortalCacheNames;
    }

    public boolean isBlockingPortalCacheAllowed() {
        return this._blockingPortalCacheAllowed;
    }

    public boolean isClusterAware() {
        return this._clusterAware;
    }

    public boolean isTransactionalPortalCacheEnabled() {
        return this._transactionalPortalCacheEnabled;
    }

    public boolean registerPortalCacheManagerListener(PortalCacheManagerListener portalCacheManagerListener) {
        return this.aggregatedPortalCacheManagerListener.addPortalCacheListener(portalCacheManagerListener);
    }

    public void removePortalCache(String portalCacheName) {
        this.portalCaches.remove(portalCacheName);
        this.doRemovePortalCache(portalCacheName);
    }

    public void setBlockingPortalCacheAllowed(boolean blockingPortalCacheAllowed) {
        this._blockingPortalCacheAllowed = blockingPortalCacheAllowed;
    }

    public void setClusterAware(boolean clusterAware) {
        this._clusterAware = clusterAware;
    }

    public void setMpiOnly(boolean mpiOnly) {
        this._mpiOnly = mpiOnly;
    }

    public void setPortalCacheManagerName(String portalCacheManagerName) {
        this._portalCacheManagerName = portalCacheManagerName;
    }

    public void setTransactionalPortalCacheEnabled(boolean transactionalPortalCacheEnabled) {
        this._transactionalPortalCacheEnabled = transactionalPortalCacheEnabled;
    }

    public void setTransactionalPortalCacheNames(String[] transactionalPortalCacheNames) {
        this._transactionalPortalCacheNames = transactionalPortalCacheNames;
    }

    public boolean unregisterPortalCacheManagerListener(PortalCacheManagerListener portalCacheManagerListener) {
        return this.aggregatedPortalCacheManagerListener.removePortalCacheListener(portalCacheManagerListener);
    }

    public void unregisterPortalCacheManagerListeners() {
        this.aggregatedPortalCacheManagerListener.clearAll();
    }

    protected abstract PortalCache<K, V> createPortalCache(PortalCacheConfiguration var1);

    protected abstract void doClearAll();

    protected abstract void doDestroy();

    protected abstract void doRemovePortalCache(String var1);

    protected abstract PortalCacheManagerConfiguration getPortalCacheManagerConfiguration();

    protected void initialize() {
        if (this._portalCacheManagerConfiguration != null || this._mpiOnly && SPIUtil.isSPI()) {
            return;
        }
        if (Validator.isNull((String)this._portalCacheManagerName)) {
            throw new IllegalArgumentException("Portal cache manager name is not specified");
        }
        this.initPortalCacheManager();
        this._portalCacheManagerConfiguration = this.getPortalCacheManagerConfiguration();
        this._defaultPortalCacheConfiguration = this._portalCacheManagerConfiguration.getDefaultPortalCacheConfiguration();
        for (Properties properties : this._portalCacheManagerConfiguration.getPortalCacheManagerListenerPropertiesSet()) {
            PortalCacheManagerListener portalCacheManagerListener = this.portalCacheManagerListenerFactory.create(this, properties);
            if (portalCacheManagerListener == null) continue;
            this.registerPortalCacheManagerListener(portalCacheManagerListener);
        }
    }

    protected abstract void initPortalCacheManager();

    protected boolean isTransactionalPortalCache(String portalCacheName) {
        for (String namePattern : this.getTransactionalPortalCacheNames()) {
            if (!StringUtil.wildcardMatches((String)portalCacheName, (String)namePattern, (char)'?', (char)'*', (char)'%', (boolean)true)) continue;
            return true;
        }
        return false;
    }

    protected void reconfigPortalCache(PortalCacheManagerConfiguration portalCacheManagerConfiguration) {
        for (String portalCacheName : portalCacheManagerConfiguration.getPortalCacheNames()) {
            PortalCacheConfiguration portalCacheConfiguration = portalCacheManagerConfiguration.getPortalCacheConfiguration(portalCacheName);
            this._portalCacheManagerConfiguration.putPortalCacheConfiguration(portalCacheName, portalCacheConfiguration);
            PortalCache portalCache = (PortalCache)this.portalCaches.get(portalCacheName);
            if (portalCache == null) continue;
            this.removeConfigurableEhcachePortalCacheListeners(portalCache);
            this._initPortalCacheListeners(portalCache, portalCacheConfiguration);
        }
    }

    protected abstract void removeConfigurableEhcachePortalCacheListeners(PortalCache<K, V> var1);

    private void _initPortalCacheListeners(PortalCache<K, V> portalCache, PortalCacheConfiguration portalCacheConfiguration) {
        if (portalCacheConfiguration == null) {
            return;
        }
        for (Properties properties : portalCacheConfiguration.getPortalCacheListenerPropertiesSet()) {
            PortalCacheListener portalCacheListener = this.portalCacheListenerFactory.create(properties);
            if (portalCacheListener == null) continue;
            PortalCacheListenerScope portalCacheListenerScope = (PortalCacheListenerScope)properties.remove("PORTAL_CACHE_LISTENER_PROPERTIES_KEY_SCOPE");
            if (portalCacheListenerScope == null) {
                portalCacheListenerScope = PortalCacheListenerScope.ALL;
            }
            portalCache.registerPortalCacheListener(portalCacheListener, portalCacheListenerScope);
        }
    }

    private void _verifyPortalCache(PortalCache<K, V> portalCache, boolean blocking, boolean mvcc) {
        if (!(mvcc != portalCache.isMVCC() || this.isBlockingPortalCacheAllowed() && blocking != portalCache.isBlocking())) {
            return;
        }
        StringBundler sb = new StringBundler(11);
        sb.append("Unable to get portal cache ");
        sb.append(portalCache.getPortalCacheName());
        sb.append(" from portal cache manager ");
        sb.append(this._portalCacheManagerName);
        sb.append(" as a ");
        if (this.isBlockingPortalCacheAllowed() && blocking) {
            sb.append("blocking ");
        } else {
            sb.append("non-blocking ");
        }
        if (mvcc) {
            sb.append("MVCC ");
        } else {
            sb.append("non-MVCC ");
        }
        sb.append("portal cache, cause a ");
        if (this.isBlockingPortalCacheAllowed() && portalCache.isBlocking()) {
            sb.append("blocking ");
        } else {
            sb.append("non-blocking ");
        }
        if (portalCache.isMVCC()) {
            sb.append("MVCC ");
        } else {
            sb.append("non-MVCC ");
        }
        sb.append("portal cache with same name exists.");
        throw new IllegalStateException(sb.toString());
    }
}

