/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bundle.blacklist.internal;

import com.liferay.osgi.util.bundle.BundleStartLevelUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.bundle.blacklist.internal.ParamUtil;
import com.liferay.portal.bundle.blacklist.internal.UninstalledBundleData;
import com.liferay.portal.bundle.blacklist.internal.WebBundleInstaller;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.lpkg.deployer.LPKGDeployer;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;

public class BundleUtil {
    public static void refreshBundles(FrameworkWiring frameworkWiring, List<Bundle> refreshBundles) {
        final DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        frameworkWiring.refreshBundles(refreshBundles, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent frameworkEvent) {
                defaultNoticeableFuture.set((Object)frameworkEvent);
            }
        }});
        try {
            FrameworkEvent frameworkEvent = (FrameworkEvent)defaultNoticeableFuture.get();
            if (frameworkEvent.getType() != 4) {
                throw frameworkEvent.getThrowable();
            }
        }
        catch (Throwable t) {
            ReflectionUtil.throwException((Throwable)t);
        }
    }

    public static void reinstallBundle(FrameworkWiring frameworkWiring, UninstalledBundleData uninstalledBundleData, BundleContext bundleContext, LPKGDeployer lpkgDeployer) throws Exception {
        Bundle bundle = null;
        String location = uninstalledBundleData.getLocation();
        Map<String, String[]> parameters = ParamUtil.getParameterMap(location);
        Object[] lpkgPath = parameters.get("lpkgPath");
        Object[] protocol = parameters.get("protocol");
        Object[] webContextPath = parameters.get("Web-ContextPath");
        if (parameters.isEmpty() && location.endsWith(".lpkg")) {
            URI uri = new URI(location);
            uri = uri.normalize();
            bundle = bundleContext.installBundle(location, lpkgDeployer.toBundle(new File(uri.getPath())));
        } else {
            if (ArrayUtil.isNotEmpty((Object[])lpkgPath)) {
                bundle = bundleContext.getBundle((String)lpkgPath[0]);
                BundleUtil.refreshBundles(frameworkWiring, Collections.singletonList(bundle));
                return;
            }
            if (ArrayUtil.isNotEmpty((Object[])protocol) && ((String)protocol[0]).equals("lpkg") && ArrayUtil.isNotEmpty((Object[])webContextPath)) {
                String contextName = ((String)webContextPath[0]).substring(1);
                for (Bundle installedBundle : bundleContext.getBundles()) {
                    Dictionary headers = installedBundle.getHeaders("");
                    if (!contextName.equals(headers.get("Liferay-WAB-Context-Name"))) continue;
                    BundleUtil.refreshBundles(frameworkWiring, Collections.singletonList(installedBundle));
                }
                return;
            }
            if (location.startsWith("webbundle:")) {
                WebBundleInstaller webBundleInstaller = new WebBundleInstaller(bundleContext, location, uninstalledBundleData.getStartLevel());
                webBundleInstaller.open();
                return;
            }
            bundle = bundleContext.installBundle(location);
        }
        BundleStartLevelUtil.setStartLevelAndStart((Bundle)bundle, (int)uninstalledBundleData.getStartLevel(), (BundleContext)bundleContext);
    }
}

