/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.bundle.blacklist.internal;

import com.liferay.portal.bundle.blacklist.internal.BundleBlacklistConfiguration;
import com.liferay.portal.bundle.blacklist.internal.BundleUtil;
import com.liferay.portal.bundle.blacklist.internal.SelfMonitorBundleListener;
import com.liferay.portal.bundle.blacklist.internal.UninstalledBundleData;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.lpkg.deployer.LPKGDeployer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.bundle.blacklist.internal.BundleBlacklistConfiguration"}, immediate=true, service={BundleBlacklist.class})
public class BundleBlacklist {
    private static final String _BLACKLIST_FILE_NAME = "blacklist.properties";
    private static final Log _log = LogFactoryUtil.getLog(BundleBlacklist.class);
    private static final Pattern _pattern = Pattern.compile("\\{location=([^,]+), startLevel=(\\d+)\\}");
    private Set<String> _blacklistBundleSymbolicNames;
    private File _blacklistFile;
    private final BundleListener _bundleListener = new SynchronousBundleListener(){

        public void bundleChanged(BundleEvent bundleEvent) {
            if (bundleEvent.getType() == 1) {
                BundleBlacklist.this._processBundle(bundleEvent.getBundle());
            }
        }
    };
    @Reference
    private LPKGDeployer _lpkgDeployer;
    private BundleListener _selfMonitorBundleListener;
    private final Map<String, UninstalledBundleData> _uninstalledBundles = new ConcurrentHashMap<String, UninstalledBundleData>();

    public List<String> getBlacklistBundleSymbolicNames() {
        return new ArrayList<String>(this._uninstalledBundles.keySet());
    }

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext, Map<String, String> properties) throws Exception {
        Bundle bundle = bundleContext.getBundle();
        this._blacklistFile = bundle.getDataFile(_BLACKLIST_FILE_NAME);
        Bundle systemBundle = bundleContext.getBundle(0L);
        BundleContext systemBundleContext = systemBundle.getBundleContext();
        FrameworkWiring frameworkWiring = (FrameworkWiring)systemBundle.adapt(FrameworkWiring.class);
        if (this._selfMonitorBundleListener == null) {
            this._selfMonitorBundleListener = new SelfMonitorBundleListener(bundle, systemBundleContext, frameworkWiring, this._lpkgDeployer, this._uninstalledBundles);
        }
        systemBundleContext.addBundleListener(this._selfMonitorBundleListener);
        this._loadFromBlacklistFile();
        BundleBlacklistConfiguration bundleBlacklistConfiguration = (BundleBlacklistConfiguration)ConfigurableUtil.createConfigurable(BundleBlacklistConfiguration.class, properties);
        this._blacklistBundleSymbolicNames = new HashSet<String>(Arrays.asList(bundleBlacklistConfiguration.blacklistBundleSymbolicNames()));
        this._blacklistBundleSymbolicNames.remove(bundle.getSymbolicName());
        bundleContext.addBundleListener(this._bundleListener);
        this._scanBundles(bundleContext, frameworkWiring);
        Set<Map.Entry<String, UninstalledBundleData>> entrySet = this._uninstalledBundles.entrySet();
        Iterator<Map.Entry<String, UninstalledBundleData>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, UninstalledBundleData> entry = iterator.next();
            String symbolicName = entry.getKey();
            if (this._blacklistBundleSymbolicNames.contains(symbolicName)) continue;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Reinstalling bundle " + symbolicName));
            }
            BundleUtil.reinstallBundle(frameworkWiring, entry.getValue(), bundleContext, this._lpkgDeployer);
            iterator.remove();
            this._removeFromBlacklistFile(symbolicName);
        }
    }

    private void _addToBlacklistFile(String symbolicName, UninstalledBundleData uninstalledBundleData) throws IOException {
        Throwable throwable;
        Properties blacklistProperties = new Properties();
        if (this._blacklistFile.exists()) {
            throwable = null;
            try (FileInputStream inputStream = new FileInputStream(this._blacklistFile);){
                blacklistProperties.load(inputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        blacklistProperties.setProperty(symbolicName, uninstalledBundleData.toString());
        throwable = null;
        try (FileOutputStream outputStream = new FileOutputStream(this._blacklistFile);){
            blacklistProperties.store(outputStream, null);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    private void _loadFromBlacklistFile() throws IOException {
        if (!this._blacklistFile.exists()) {
            return;
        }
        Properties blacklistProperties = new Properties();
        FileInputStream inputStream = new FileInputStream(this._blacklistFile);
        Object object = null;
        try {
            blacklistProperties.load(inputStream);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (object != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)inputStream).close();
                }
            }
        }
        Set<Map.Entry<Object, Object>> entries = blacklistProperties.entrySet();
        for (Map.Entry entry : entries) {
            String value = (String)entry.getValue();
            Matcher matcher = _pattern.matcher(value);
            if (!matcher.matches()) continue;
            this._uninstalledBundles.put((String)entry.getKey(), new UninstalledBundleData(matcher.group(1), Integer.valueOf(matcher.group(2))));
        }
    }

    private boolean _processBundle(Bundle bundle) {
        String symbolicName = bundle.getSymbolicName();
        if (this._blacklistBundleSymbolicNames.contains(symbolicName)) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Stopping blacklisted bundle " + bundle));
            }
            BundleStartLevel bundleStartLevel = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
            UninstalledBundleData uninstalledBundleData = new UninstalledBundleData(bundle.getLocation(), bundleStartLevel.getStartLevel());
            this._uninstalledBundles.put(symbolicName, uninstalledBundleData);
            try {
                bundle.uninstall();
                this._addToBlacklistFile(symbolicName, uninstalledBundleData);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to uninstall " + bundle), (Throwable)e);
                this._uninstalledBundles.remove(symbolicName);
            }
            return true;
        }
        return false;
    }

    private void _removeFromBlacklistFile(String symbolicName) throws IOException {
        Throwable throwable;
        Properties blacklistProperties = new Properties();
        if (this._blacklistFile.exists()) {
            throwable = null;
            try (FileInputStream inputStream = new FileInputStream(this._blacklistFile);){
                blacklistProperties.load(inputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        blacklistProperties.remove(symbolicName);
        throwable = null;
        try (FileOutputStream outputStream = new FileOutputStream(this._blacklistFile);){
            blacklistProperties.store(outputStream, null);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    private void _scanBundles(BundleContext bundleContext, FrameworkWiring frameworkWiring) {
        ArrayList<Bundle> uninstalledBundles = new ArrayList<Bundle>();
        for (Bundle bundle : bundleContext.getBundles()) {
            if (bundle.getState() == 1 || !this._processBundle(bundle)) continue;
            uninstalledBundles.add(bundle);
        }
        if (!uninstalledBundles.isEmpty()) {
            BundleUtil.refreshBundles(frameworkWiring, uninstalledBundles);
        }
    }
}

