/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.background.task.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutorRegistry;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={BackgroundTaskExecutorRegistry.class})
public class BackgroundTaskExecutorRegistryImpl
implements BackgroundTaskExecutorRegistry {
    private final Map<String, ServiceRegistration<BackgroundTaskExecutor>> _backgroundTaskExecutorRegistrations = new HashMap<String, ServiceRegistration<BackgroundTaskExecutor>>();
    private ServiceTrackerMap<String, BackgroundTaskExecutor> _backgroundTaskExecutors;
    private BundleContext _bundleContext;

    public synchronized BackgroundTaskExecutor getBackgroundTaskExecutor(String backgroundTaskExecutorClassName) {
        return (BackgroundTaskExecutor)this._backgroundTaskExecutors.getService((Object)backgroundTaskExecutorClassName);
    }

    public synchronized void registerBackgroundTaskExecutor(String backgroundTaskExecutorClassName, BackgroundTaskExecutor backgroundTaskExecutor) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("background.task.executor.class.name", backgroundTaskExecutorClassName);
        ServiceRegistration serviceRegistration = this._bundleContext.registerService(BackgroundTaskExecutor.class, (Object)backgroundTaskExecutor, (Dictionary)properties);
        this._backgroundTaskExecutorRegistrations.put(backgroundTaskExecutorClassName, (ServiceRegistration<BackgroundTaskExecutor>)serviceRegistration);
    }

    public synchronized void unregisterBackgroundTaskExecutor(String backgroundTaskExecutorClassName) {
        if (!this._backgroundTaskExecutorRegistrations.containsKey(backgroundTaskExecutorClassName)) {
            return;
        }
        ServiceRegistration<BackgroundTaskExecutor> serviceRegistration = this._backgroundTaskExecutorRegistrations.get(backgroundTaskExecutorClassName);
        serviceRegistration.unregister();
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._backgroundTaskExecutors = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, BackgroundTaskExecutor.class, (String)"background.task.executor.class.name");
    }

    @Deactivate
    protected synchronized void deactivate() {
        this._backgroundTaskExecutors.close();
        this._bundleContext = null;
        for (ServiceRegistration<BackgroundTaskExecutor> serviceRegistration : this._backgroundTaskExecutorRegistrations.values()) {
            serviceRegistration.unregister();
        }
        this._backgroundTaskExecutorRegistrations.clear();
    }
}

