/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.apio.internal.architect.uri.mapper;

import com.liferay.apio.architect.functional.Try;
import com.liferay.apio.architect.uri.Path;
import com.liferay.apio.architect.uri.mapper.PathIdentifierMapper;
import com.liferay.portal.apio.identifier.ClassNameClassPK;
import com.liferay.portal.kernel.model.ClassNameModel;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Optional;
import javax.ws.rs.BadRequestException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class ClassNameClassPKIdentifierMapper
implements PathIdentifierMapper<ClassNameClassPK> {
    @Reference
    private ClassNameLocalService _classNameLocalService;

    public ClassNameClassPK map(Path path) {
        String id = path.getId();
        String[] components = id.split(":");
        if (components.length != 2) {
            throw new BadRequestException(id + " should be a string with the form \"classNameId:classPK\"");
        }
        long classNameId = this._getAsLong(components[0]);
        long classPK = this._getAsLong(components[1]);
        String className = Optional.ofNullable(this._classNameLocalService.fetchByClassNameId(classNameId)).map(ClassNameModel::getClassName).orElseThrow(() -> new BadRequestException("Unable to convert " + classNameId + " to a class name"));
        return ClassNameClassPK.create((String)className, (long)classPK);
    }

    public Path map(String name, ClassNameClassPK classNameClassPK) {
        String className = classNameClassPK.getClassName();
        long classNameId = this._classNameLocalService.getClassNameId(className);
        String id = classNameId + ":" + classNameClassPK.getClassPK();
        return new Path(name, id);
    }

    private long _getAsLong(String string) {
        return (Long)Try.fromFallible(() -> GetterUtil.getLong((String)string)).orElseThrow(() -> new BadRequestException("Unable to convert " + string + " to a long"));
    }
}

