/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.apio.internal.architect.logger;

import com.liferay.apio.architect.error.APIError;
import com.liferay.apio.architect.logger.ApioLogger;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class ApioLoggerImpl
implements ApioLogger {
    private static final Log _log = LogFactoryUtil.getLog(ApioLoggerImpl.class);

    public void error(APIError apiError) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)this._getExceptionMessage(apiError), (Throwable)apiError.getException());
        } else {
            _log.error((Object)this._getExceptionMessage(apiError));
        }
    }

    public void warning(String message) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)message);
        } else {
            _log.warn((Object)message);
        }
    }

    private String _getExceptionMessage(APIError apiError) {
        Optional optional = apiError.getDescription();
        return optional.orElseGet(() -> {
            Exception exception = apiError.getException();
            String message = exception.getMessage();
            if (Validator.isNotNull((String)message)) {
                return message;
            }
            return apiError.toString();
        });
    }
}

