/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.apio.internal.architect.servlet.filter;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BaseFilter;
import com.liferay.portal.kernel.util.Portal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"dispatcher=FORWARD", "dispatcher=REQUEST", "servlet-context-name=", "servlet-filter-name=API Documentation Filter", "url-pattern=/*"}, service={Filter.class})
public class APIDocumentationFilter
extends BaseFilter {
    private String _applicationPath;
    @Reference
    private Portal _portal;

    public boolean isFilterEnabled() {
        return this._applicationPath != null;
    }

    protected Log getLog() {
        return LogFactoryUtil.getLog(((Object)((Object)this)).getClass());
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(this._getApiDocumentationURL(request));
        sb.append(" rel=\"http://www.w3.org/ns/hydra/core#apiDocumentation\">");
        response.addHeader("Link", sb.toString());
        super.processFilter(request, response, filterChain);
    }

    @Reference(target="(osgi.jaxrs.name=apio-application)", unbind="-")
    protected void setApplication(ServiceReference<Application> serviceReference) {
        this._applicationPath = (String)serviceReference.getProperty("osgi.jaxrs.application.base");
    }

    private String _getApiDocumentationURL(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(this._portal.getPortalURL(request));
        sb.append("/o");
        sb.append(this._applicationPath);
        sb.append("/doc");
        return sb.toString();
    }
}

